<?php

namespace App\Filament\Resources;

use App\Filament\Resources\MessageResource\Pages;
use App\Models\Message;
use DateTime;
use Filament\Forms\Components\DateTimePicker;
use Filament\Forms\Components\Group;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;
use Illuminate\Support\Facades\Lang;

class MessageResource extends Resource
{
    protected static ?string $model = Message::class;
    protected static ?string $navigationIcon = 'heroicon-o-envelope';
    protected static ?string $recordTitleAttribute = 'email';
    protected static ?int $navigationSort = 22;
    protected static ?string $navigationGroup = 'Tartalom';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Group::make()
                    ->schema([
                        Section::make()
                            ->schema([
                                TextInput::make('name')
                                    ->label(Lang::get('messages.name'))
                                    ->required(),
                                TextInput::make('email')
                                    ->label(Lang::get('messages.email'))
                                    ->required(),
                                TextInput::make('phone')
                                    ->label('Telefon')
                                    ->required(),
                                Textarea::make('body')
                                    ->label('Üzenet')
                                    ->required(),
                            ]),
                    ]),
                Group::make()
                    ->schema([
                        Section::make()
                            ->schema([
                                DateTimePicker::make('created_at')
                                    ->label('Létrehozva')
                                    ->disabled(),
                                DateTimePicker::make('updated_at')
                                    ->label('Módosítva')
                                    ->disabled(),
                            ]),
                    ])
            ]);
    }

    public static function getModelLabel(): string {
        return __('messages.message');
    }

    public static function getPluralModelLabel(): string {
        return __('messages.messages');
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('name')
                    ->label(Lang::get('messages.name'))
                    ->searchable()
                    ->sortable(),
                TextColumn::make('email')
                    ->label(Lang::get('messages.email'))
                    ->searchable()
                    ->sortable(),
                TextColumn::make('phone')
                    ->label(Lang::get('messages.phone'))
                    ->searchable()
                    ->sortable(),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ])
            ->defaultSort('id', 'desc');
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListMessages::route('/'),
            'create' => Pages\CreateMessage::route('/create'),
            'edit' => Pages\EditMessage::route('/{record}/edit'),
        ];
    }
}
