<?php

namespace App\Http\Controllers;

use App\Models\Page;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class PageController extends Controller
{
    public function page(string $slug) {
        $page = Page::where('slug', $slug)->first();

        if($page == null) {
            return abort(404);
        }

        return view('page', [
            'page' => $page,
            'body' => Str::markdown($page->content),
        ]);
    }
}
