<?php

namespace App\Http\Middleware;

use App\Models\Config;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class Maintenance {
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response {
        $maintenance = Config::where('name', 'maintenance')->first();

        if ($maintenance->value == '1') {
            $user = $request->user();

            if( $user == null ) {
                return redirect()->route('maintenance');
            } else if ( $user->role != 'root' ) {
                return redirect()->route('maintenance');
            }
        }

        return $next($request);
    }
}
