<?php

namespace App\Http\Middleware;

use App\Enums\RoleEnum;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class RedirectIfNotAdmin
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = $request->user();

        if($user != null) {
            if( $user->role !== RoleEnum::ROOT->value
                && $user->role !== RoleEnum::ADMIN->value ) {
                return redirect()->route('home');
            }
        }

        return $next($request);
    }
}
