<?php

namespace App\Livewire;

use App\Models\Message;
use Livewire\Attributes\Rule;
use Livewire\Component;

class ContactForm extends Component
{
    #[Rule('required|min:3|max:50')]
    public $name;
    #[Rule('required|email')]
    public $email;
    #[Rule('required|min:5|max:50')]
    public $phone;
    #[Rule('required|min:10')]
    public $body;

    public function create() {
        $this->validate();
        Message::create([
            'name' => $this->name,
            'email' => $this->email,
            'phone' => $this->phone,
            'body' => $this->body
        ]);

        $this->reset();
        session()->flash('success', 'Üzenet sikeresen elküldve!');
    }

    public function render() {
        return view('livewire.contact-form');
    }
}
