<?php

namespace App\Livewire;

use Illuminate\Http\Request;
use Livewire\Component;

class CookiePopup extends Component {
    public bool $show = true;

    public function mount(Request $request) {
        if ($request->getSession()->has('cookie-popup') == '1') {
            $this->show = false;
        }
    }

    public function setShow(Request $request) {
        $this->show = false;
        $request->getSession()->set('cookie-popup', '1');
    }

    public function render() {
        return view('livewire.cookie-popup');
    }
}
