<?php

namespace App\Livewire;

use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;
use Livewire\Attributes\Rule;
use Illuminate\Support\Facades\Hash;

class UserForm extends Component
{
    #[Rule('required|min:3')]
    public $name;

    #[Rule('required|min:3')]
    public $email;

    #[Rule('required|min:3')]
    public $phone;

    #[Rule('required|min:3')]
    public $password;

    #[Rule('required|min:3')]
    public $repassword;

    public $samePassword = false;
    public $saved = false;

    public function mount() {
        $user = Auth::user();

        $this->name = $user->name;
        $this->email = $user->email;
        $this->phone = $user->phone;
    }

    public function update() {
        $this->validate();

        if($this->password === $this->repassword) {
            $auth = Auth::user();
            $user = User::where('id', $auth->id)->first();
            $user->name = $this->name;
            $user->phone = $this->phone;
            $user->password = Hash::make($this->password);
            $user->save();

            $this->saved = true;
        } else {
            $this->samePassword = true;
        }
    }

    public function render() {
        return view('livewire.user-form');
    }
}
