<?php

namespace App\Services;

class AllergensService {

    public static function renderIcons(string $allergens): string {
        $allergensArray = explode(';', $allergens);
        $html = '';

        foreach ($allergensArray as $key => $allergen) {
            $html .= self::allergenToHtml($allergen);
        }

        return $html;
    }

    private static function allergenToHtml($allergen): string {
        $icon = '';
        switch ($allergen) {
            case '1':
                $icon = '<img class="w-4 h-4 mr-1" src="/images/1-gluten.png" alt="Glutén" />';
                break;
            case '2':
                $icon = '<img class="w-4 h-4 mr-1" src="/images/2-rakfelek.png" alt="Rákfélék" />';
                break;
            case '3':
                $icon = '<img class="w-4 h-4 mr-1" src="/images/3-tojas.png" alt="Tojás" />';
                break;
            case '4':
                $icon = '<img class="w-4 h-4 mr-1" src="/images/4-halak.png" alt="Halak" />';
                break;
            case '5':
                $icon = '<img class="w-4 h-4 mr-1" src="/images/5-mogyoro.png" alt="Mogyoró" />';
                break;
            case '6':
                $icon = '<img class="w-4 h-4 mr-1" src="/images/6-szoja.png" alt="Szója" />';
                break;
            case '7':
                $icon = '<img class="w-4 h-4 mr-1" src="/images/7-tej.png" alt="Tej" />';
                break;
            case '8':
                $icon = '<img class="w-4 h-4 mr-1" src="/images/8-dio.png" alt="Dió" />';
                break;
            case '9':
                $icon = '<img class="w-4 h-4 mr-1" src="/images/9-zeller.png" alt="Zeller" />';
                break;
            case '10':
                $icon = '<img class="w-4 h-4 mr-1" src="/images/10-mustar.png" alt="Mustár" />';
                break;
            case '11':
                $icon = '<img class="w-4 h-4 mr-1" src="/images/11-szezammag.png" alt="Szezámmag" />';
                break;
            case '12':
                $icon = '<img class="w-4 h-4 mr-1" src="/images/12-kendioxid.png" alt="Kéndioxid" />';
                break;
            case '13':
                $icon = '<img class="w-4 h-4 mr-1" src="/images/13-csillagfurt.png" alt="Csillagfürt" />';
                break;
            case '14':
                $icon = '<img class="w-4 h-4 mr-1" src="/images/14-puhatestuek.png" alt="Puhatestűek" />';
                break;
            default:
                $icon = '-';
                break;
        }

        return $icon;
    }
}