<?php

namespace App\Services;

use App\Models\Order;
use App\Models\OrderFood;
use App\Models\Payment;
use App\Models\User;
use Illuminate\Http\Request;

class CheckoutService {
    private Order $order;

    public function __construct(
        private Request $request,
        private ?User $user) {
            $this->order = $this->init();
    }

    public function getTotal(): object {
        $total = [
            'food' => 0,
            'quantity_discount' => 0,
            'pack' => 0,
            'delivery' => 0,
            'payment' => 0,
            'coupon' => 0,
            'total' => 0
        ];
        $sumQuantity = 0;
        $orderFoods = OrderFood::where('order_id', $this->order->id)->get();
        $payment = Payment::where('id', $this->order->payment_id)->first();

        if($payment != null) {
            if($payment->price > 0) {
                $total['payment'] = $payment->price;
            }
        }

        foreach ($orderFoods as $item) {
            $sumQuantity += $item->quantity;
            $total['food'] += ($item->price * $item->quantity);
        }

        $total['quantity_discount'] = DiscountService::getOrderQuantityDiscount($orderFoods);

        $total['total'] += $total['food'];
        $total['total'] += $total['pack'];
        $total['total'] += $total['payment'];
        $total['total'] += $total['delivery'];
        $total['total'] -= $total['coupon'];
        $total['total'] -= $total['quantity_discount'];

        return (object)$total;
    }

    private function init(): ?Order {
        $orderId = $this->request->session()->get('order_id');
        $order = Order::where('id', $orderId)->first();

        return $order;
    }

}