<?php

namespace App\Services;

use App\Models\Coupon;
use App\Models\Order;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;

class CouponService {

    public static function validate(?string $code): bool {
        if($code == null) {
            return false;
        }
        $coupon = Coupon::where('code', $code)->first();

        if(Carbon::parse($coupon->expired_at) <= Carbon::now()) {
            return false;
        }

        if($coupon->count > 0) {
            $user = Auth::user();

            if($user != null) {
                $orders = Order::where('coupon_id', $coupon->id)
                                ->where('user_id', $user->id)
                                ->get();
                $used = count($orders);

                if($coupon->count <= $used) {
                    return false;
                }
            }
        }

        return true;
    }

}