<?php

namespace App\Services;

use DateTime;
use DateTimeZone;

class DateTimeService
{

    public static function now() {
        return new DateTime('now', new DateTimeZone('Europe/Budapest'));
    }

    public static function get($datetime) {
        return new DateTime($datetime->format('Y-m-d H:i:s'), new DateTimeZone('Europe/Budapest'));
    }

    public static function getCloseDate($datetime) {
        $dayNumber = $datetime->format('N');
        $closeDate = self::get($datetime)->modify('-1 day');

        if($dayNumber == 6) {
            $closeDate = $closeDate->modify('-1 day');
        }

        if($dayNumber == 7) {
            $closeDate = $closeDate->modify('-2 day');
        }

        $closeDate = $closeDate->modify('+16 hour');

        return $closeDate;
    }

    public static function getDateString($date): string {
        return self::get($date)->format('Y-m-d');
    }

    public static function getDateTimeString($datetime): string {
        return self::get($datetime)->format('Y-m-d H:i:s');
    }

    public static function getNowString(): string {
        return self::now()->format('Y-m-d H:i:s');
    }

    public static function getDayName($datetime, $lang = 'en') {
        $day = 'error-day-name';

        switch ($lang) {
            case 'hu':
                $day = self::getHuDayName($datetime);
                break;
            default:
                $day = $datetime->format('l');
                break;
        }

        return $day;
    }

    private static function getHuDayName($datetime): string {
        $day = 'error-day-name-hu';

        switch ($datetime->format('l')) {
            case 'Monday':
                $day = 'Hétfő';
                break;
            case 'Tuesday':
                $day = 'Kedd';
                break;
            case 'Wednesday':
                $day = 'Szerda';
                break;
            case 'Thursday':
                $day = 'Csütörtök';
                break;
            case 'Friday':
                $day = 'Péntek';
                break;
            case 'Saturday':
                $day = 'Szombat';
                break;
            case 'Sunday':
                $day = 'Vasárnap';
                break;
            default:
                $day = 'error-default-hu';
                break;
        }

        return $day;
    }

}