<?php

namespace App\Services;

use App\Models\Config;
use Illuminate\Support\Facades\Mail;

class DeveloperService {

    public static function sendErrorEmail(string $error, string $url): void {
        $developerEmail = Config::where('name', 'developer_email')->first();
        Mail::to($developerEmail->value)
            ->send(new \App\Mail\DeveloperError(
                            $error,
                            $url
                        )
                    );
    }

}