<?php

namespace App\Services;

use App\Models\Food;
use App\Models\QuantityDiscount;
use Illuminate\Support\Collection;

class DiscountService {

    public static function getCartQuantityDiscount(Collection $cartFoods): float {
        $quantityDiscounts = QuantityDiscount::where('is_active', true)->get();
        $menuTypeCount = [];
        $total = 0;

        foreach ($cartFoods as $food) {
            $menuTypeFood = Food::where('id', $food->food_id)->first();
            if(!array_key_exists($menuTypeFood->menu_type_id, $menuTypeCount)) {
                $menuTypeCount[$menuTypeFood->menu_type_id] = 0;
            }
            $menuTypeCount[$menuTypeFood->menu_type_id]++;
        }

        if(count($menuTypeCount) > 0 && count($quantityDiscounts) > 0) {
            foreach ($quantityDiscounts as $discount) {
                if(in_array($discount->menu_type_id, array_keys($menuTypeCount))) {
                    if($menuTypeCount[$discount->menu_type_id] >= $discount->quantity) {
                        $total += ($discount->discount * $menuTypeCount[$discount->menu_type_id]);
                    }
                }
            }
        }

        return $total;
    }

    public static function getOrderQuantityDiscount(Collection $orderFoods): float {
        $quantityDiscounts = QuantityDiscount::where('is_active', true)->get();
        $menuTypeCount = [];
        $total = 0;

        foreach ($orderFoods as $food) {
            $menuTypeFood = Food::where('id', $food->food_id)->first();
            if(!array_key_exists($menuTypeFood->menu_type_id, $menuTypeCount)) {
                $menuTypeCount[$menuTypeFood->menu_type_id] = 0;
            }
            $menuTypeCount[$menuTypeFood->menu_type_id]++;
        }

        if(count($menuTypeCount) > 0 && count($quantityDiscounts) > 0) {
            foreach ($quantityDiscounts as $discount) {
                if(in_array($discount->menu_type_id, array_keys($menuTypeCount))) {
                    if($menuTypeCount[$discount->menu_type_id] >= $discount->quantity) {
                        $total += ($discount->discount * $menuTypeCount[$discount->menu_type_id]);
                    }
                }
            }
        }

        return $total;
    }

    public static function hasDiscount($menu_type_id): bool {
        $quantityDiscounts = QuantityDiscount::where('is_active', true)
                                            ->where('menu_type_id', $menu_type_id)
                                            ->get();
        if(count($quantityDiscounts) > 0) {
            return true;
        }
        return false;
    }

}