<?php

namespace App\Services;

use App\Models\MenuType;
use App\Models\Food;
use DateTime;
use Illuminate\Support\Facades\Auth;

class FoodImportService {

    public static function excelToArray($spreadsheet): array {
        $sheetData = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);
        $startRow = 3;
        $foods = [
            'monday' => [],
            'tuesday' => [],
            'wednesday' => [],
            'thursday' => [],
            'friday' => [],
            'saturday' => [],
            'sunday' => [],
        ];
        $cols = [
            'monday' => [
                'menu_type' => 'A',
                'name' => 'C',
                'allergens' => 'D',
                'price' => 'E'
            ],
            'tuesday' => [
                'menu_type' => 'A',
                'name' => 'F',
                'allergens' => 'G',
                'price' => 'H'
            ],
            'wednesday' => [
                'menu_type' => 'A',
                'name' => 'I',
                'allergens' => 'J',
                'price' => 'K'
            ],
            'thursday' => [
                'menu_type' => 'A',
                'name' => 'L',
                'allergens' => 'M',
                'price' => 'N'
            ],
            'friday' => [
                'menu_type' => 'A',
                'name' => 'O',
                'allergens' => 'P',
                'price' => 'Q'
            ],
            'saturday' => [
                'menu_type' => 'A',
                'name' => 'R',
                'allergens' => 'S',
                'price' => 'T'
            ],
        ];

        $i = 1;
        foreach ($sheetData as $value) {
            if($i >= $startRow) {
                $foods['monday'][] = [
                    'menu_type' => $value[$cols['monday']['menu_type']],
                    'name' => $value[$cols['monday']['name']],
                    'allergens' => $value[$cols['monday']['allergens']],
                    'price' => $value[$cols['monday']['price']]
                ];

                $foods['tuesday'][] = [
                    'menu_type' => $value[$cols['tuesday']['menu_type']],
                    'name' => $value[$cols['tuesday']['name']],
                    'allergens' => $value[$cols['tuesday']['allergens']],
                    'price' => $value[$cols['tuesday']['price']]
                ];

                $foods['wednesday'][] = [
                    'menu_type' => $value[$cols['wednesday']['menu_type']],
                    'name' => $value[$cols['wednesday']['name']],
                    'allergens' => $value[$cols['wednesday']['allergens']],
                    'price' => $value[$cols['wednesday']['price']]
                ];

                $foods['thursday'][] = [
                    'menu_type' => $value[$cols['thursday']['menu_type']],
                    'name' => $value[$cols['thursday']['name']],
                    'allergens' => $value[$cols['thursday']['allergens']],
                    'price' => $value[$cols['thursday']['price']]
                ];

                $foods['friday'][] = [
                    'menu_type' => $value[$cols['friday']['menu_type']],
                    'name' => $value[$cols['friday']['name']],
                    'allergens' => $value[$cols['friday']['allergens']],
                    'price' => $value[$cols['friday']['price']]
                ];

                $foods['saturday'][] = [
                    'menu_type' => $value[$cols['saturday']['menu_type']],
                    'name' => $value[$cols['saturday']['name']],
                    'allergens' => $value[$cols['saturday']['allergens']],
                    'price' => $value[$cols['saturday']['price']]
                ];
            }
            $i++;
        }

        return $foods;
    }

    public static function import($spreadsheet, $startDate) {
        $days = self::excelToArray($spreadsheet);
        $user = Auth::user();

        try {
            $i = 0;
            foreach ($days as $day) {
                $date = new DateTime($startDate);

                if($i > 0) {
                    $date = $date->modify('+'. $i .' day');
                }

                $closeDate = DateTimeService::getCloseDate($date);
                $week = $date->format('W');

                foreach ($day as $food) {
                    if( $food['menu_type'] == null
                        && $food['name'] == null
                        && $food['price'] == null) {
                        continue;
                    }
                    $menuType = MenuType::where('excel_code', $food['menu_type'])->get();

                    if($menuType[0] instanceof MenuType) {
                        $menuType = $menuType[0];
                    }

                    $name = str_replace(',',', ', $food['name']);
                    $price = str_replace('Ft', '', $food['price']);
                    $price = (int)str_replace(',', '', $price);
                    $allergens = str_replace('.',';', $food['allergens']);
                    $allergens = str_replace(',', ';', $allergens);

                    $food = Food::create([
                        'menu_type_id' => $menuType->id,
                        'date' => $date,
                        'week' => $week,
                        'closing_at' => $closeDate,
                        'name' => $name,
                        'allergens' => $allergens,
                        'price' => $price,
                        'updated_by_id' => $user->id,
                        'created_at' => now(),
                        'updated_at' => now()
                    ]);
                    $food->save();

                    if($menuType->menu_type_id != null) {
                        $zone = Food::create([
                            'menu_type_id' => $menuType->menu_type_id,
                            'date' => $date,
                            'week' => $week,
                            'closing_at' => $closeDate,
                            'name' => $name,
                            'allergens' => $allergens,
                            'price' => $menuType->zone_menu_price,
                            'updated_by_id' => $user->id,
                            'created_at' => now(),
                            'updated_at' => now()
                        ]);
                        $zone->save();
                    }
                }
                $i++;
            }
        } catch (\Throwable $th) {
            throw $th;
        }
    }
}