<?php

namespace App\Services;

use App\Enums\OrderPaymentStatusEnum;
use App\Models\Config;
use App\Models\Coupon;
use App\Models\Order;
use App\Models\OrderFood;
use App\Models\Payment;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Mail;

class OrderService {

    public static function getTotalPrice(Order $order): Collection {
        $total = [
            'items' => [],
            'food' => 0,
            'quantity_discount' => 0,
            'pack' => 0,
            'delivery' => 0,
            'payment' => 0,
            'coupon' => 0,
            'total' => 0
        ];
        $orderFoods = OrderFood::where('order_id', $order->id)->get();
        $packCount = 0;

        foreach ($orderFoods as $item) {
            $packCount += $item->quantity;
            $total['items'][$item->id] = $item->quantity * $item->price;
            $total['food'] += $total['items'][$item->id];
        }

        $total['quantity_discount'] = DiscountService::getOrderQuantityDiscount($orderFoods);

        if($order->pack_unit_price > 0) {
            $total['pack'] = $packCount * $order->pack_unit_price;
        }

        if($order->delivery_price > 0) {
            $total['delivery'] = $order->delivery_price;
        }

        if($order->payment_price > 0) {
            $total['payment'] = $order->payment_price;
        }

        if($order->coupon_id != null) {
            $coupon = Coupon::where('id', $order->coupon_id)->first();
            if($coupon instanceof Coupon) {
                $total['coupon'] = $coupon->value;
            }
        }

        $total['total'] += $total['food'];
        $total['total'] += $total['pack'];
        $total['total'] += $total['delivery'];
        $total['total'] += $total['payment'];
        $total['total'] -= $total['coupon'];
        $total['total'] -= $total['quantity_discount'];

        return new Collection($total);
    }

    public static function sendOrderEmails(Order $order): void {
        try {
            $orderEmail = Config::where('name', 'order_email')->first();

            Mail::to($order->email)
                ->send(new \App\Mail\OrderConfirmation($order));
            Mail::to($orderEmail->value)
                ->send(new \App\Mail\OrderConfirmation($order));
        } catch (\Exception $e) {
            DeveloperService::sendErrorEmail($e->getMessage(), 'OrderService.php 75. line');
        }
    }

    public static function timeoutStatusJob(): void {
        $payment = Payment::where('slug', 'bankkartyas')->first();
        $orders = Order::where('payment_status', OrderPaymentStatusEnum::PENDING->value)
                        ->where('payment_id', $payment->id)
                        ->get();
        foreach ($orders as $order) {
            if($order->created_at->diffInMinutes(now()) > 15) {
                $order->payment_status = OrderPaymentStatusEnum::TIMEOUT->value;
                $order->save();
            }
        }
    }

}