<?php

namespace App\Services;

use App\Models\Zip;
use Illuminate\Support\Collection;

class ShippingService
{
    public static function getShippingPrice(?Zip $zip, ?Collection $cartFoods): int {
        if($zip == null || $cartFoods == null) {
            return 0;
        }

        $dates = [];
        foreach($cartFoods as $cartFood) {
            if(!in_array($cartFood->food->date, $dates)) {
                $dates[] = $cartFood->food->date;
            }
        }

        return $zip->price * count($dates);
    }
}