<?php

use App\Models\MenuType;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('menu_types', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(MenuType::class)->nullable()->constrained();
            $table->string('name');
            $table->string('slug');
            $table->boolean('is_current_week_active')->default(false);
            $table->boolean('is_next_week_active')->default(false);
            $table->integer('current_week_position')->default(0);
            $table->integer('next_week_position')->default(0);
            $table->float('zone_menu_price', 10, 2)->nullable();
            $table->string('excel_code')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('menu_types');
    }
};
