<?php

use App\Models\MenuType;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('food', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(MenuType::class)->nullable()->constrained();
            $table->date('date');
            $table->integer('week')->nullable();
            $table->dateTime('closing_at');
            $table->string('name');
            $table->longText('description')->nullable();
            $table->string('allergens')->nullable();
            $table->float('price', 10, 2);
            $table->foreignId('updated_by_id')->constrained('users');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('food');
    }
};
