<?php

use App\Enums\CouponEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('coupons', function (Blueprint $table) {
            $table->id();
            $table->string('type')->default(CouponEnum::FIX->value);
            $table->string('code');
            $table->string('name');
            $table->integer('value');
            $table->integer('count')->nullable();
            $table->datetime('expired_at');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('coupons');
    }
};
