<?php

use App\Models\Coupon;
use App\Models\Payment;
use App\Models\User;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(User::class)->nullable()->constrained();
            $table->foreignIdFor(Payment::class)->constrained();
            $table->foreignIdFor(Coupon::class)->nullable()->constrained();
            $table->string('fullname');
            $table->string('email');
            $table->string('phone');
            $table->longText('comment')->nullable();
            $table->string('delivery_country');
            $table->string('delivery_zip');
            $table->string('delivery_city');
            $table->string('delivery_address');
            $table->string('invoice_name')->nullable();
            $table->string('invoice_tax')->nullable();
            $table->string('invoice_country')->nullable();
            $table->string('invoice_zip')->nullable();
            $table->string('invoice_city')->nullable();
            $table->string('invoice_address')->nullable();
            $table->float('pack_unit_price', 10, 2)->nullable();
            $table->float('total_pack_price', 10, 2)->nullable();
            $table->float('delivery_price', 10, 2)->nullable();
            $table->float('payment_price', 10, 2)->nullable();
            $table->float('total_price', 10, 2)->nullable();
            $table->string('simplepay_order_ref')->nullable();
            $table->string('simplepay_transaction_id')->nullable();
            $table->string('payment_status')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};
