<?php

use App\Models\Food;
use App\Models\Order;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('order_food', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(Order::class)->constrained();
            $table->foreignIdFor(Food::class)->constrained();
            $table->integer('quantity')->default(1);
            $table->float('pack_unit_price', 10, 2)->nullable();
            $table->float('total_pack_price', 10, 2)->nullable();
            $table->float('price', 10, 2);
            $table->float('discount', 10, 2)->nullable();
            $table->float('total_price', 10, 2);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('order_food');
    }
};
