<?php

use App\Models\MenuType;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('quantity_discounts', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(MenuType::class)->constrained();
            $table->integer('quantity');
            $table->float('discount', 10, 2);
            $table->boolean('is_active')->default(true);
            $table->boolean('is_one_week')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('quantity_discounts');
    }
};
