<?php

namespace Database\Seeders;

use App\Models\MenuType;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class MenuTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $data = [
            [
                'name' => 'A leves',
                'zone_menu_type_id' => null,
                'zone_menu_price' => null,
                'excel_code' => 'A'
            ],
            [
                'name' => 'B leves',
                'zone_menu_type_id' => null,
                'zone_menu_price' => null,
                'excel_code' => 'B'
            ],
            [
                'name' => 'D főétel',
                'zone_menu_type_id' => null,
                'zone_menu_price' => null,
                'excel_code' => 'D'
            ],
            [
                'name' => 'G1 bundázott',
                'zone_menu_type_id' => null,
                'zone_menu_price' => null,
                'excel_code' => 'G1'
            ],
            [
                'name' => 'G2 Töltött',
                'zone_menu_type_id' => null,
                'zone_menu_price' => null,
                'excel_code' => 'G2'
            ],
            [
                'name' => 'H Rakott Tészták',
                'zone_menu_type_id' => null,
                'zone_menu_price' => null,
                'excel_code' => 'H'
            ],
            [
                'name' => 'J Főzelékek',
                'zone_menu_type_id' => null,
                'zone_menu_price' => null,
                'excel_code' => 'J'
            ],
            [
                'name' => 'd Desszert Világ',
                'zone_menu_type_id' => null,
                'zone_menu_price' => null,
                'excel_code' => 'de'
            ],
            [
                'name' => 'Menü 1',
                'zone_menu_type_id' => null,
                'zone_menu_price' => null,
                'excel_code' => 'Menü'
            ],
            [
                'name' => 'Menü 1 Zóna',
                'zone_menu_type_id' => null,
                'zone_menu_price' => null,
                'excel_code' => null
            ],
            [
                'name' => 'I Cuki Főétel',
                'zone_menu_type_id' => null,
                'zone_menu_price' => null,
                'excel_code' => 'I'
            ],
            [
                'name' => 'CM Cuki Menü',
                'zone_menu_type_id' => null,
                'zone_menu_price' => null,
                'excel_code' => 'CM'
            ],
            [
                'name' => 'E Epekímélő, Tej, Tojásmentes Menü',
                'zone_menu_type_id' => null,
                'zone_menu_price' => null,
                'excel_code' => 'E'
            ],
            [
                'name' => 'L Gluténmentes Menü',
                'zone_menu_type_id' => null,
                'zone_menu_price' => null,
                'excel_code' => 'L'
            ],
            [
                'name' => 'Nyugdíjas menü',
                'zone_menu_type_id' => null,
                'zone_menu_price' => null,
                'excel_code' => 'Nyugdíjas menü'
            ],
            [
                'name' => 'K Light&Fitness',
                'zone_menu_type_id' => null,
                'zone_menu_price' => null,
                'excel_code' => 'K'
            ]
        ];

        foreach ($data as $key => $value) {
            DB::table('menu_types')->insert([
                'menu_type_id' => $value['zone_menu_type_id'],
                'name' => $value['name'],
                'slug' => Str::slug($value['name']),
                'is_current_week_active' => true,
                'is_next_week_active' => true,
                'current_week_position' => $key + 1,
                'next_week_position' => $key + 1,
                'zone_menu_price' => $value['zone_menu_price'],
                'excel_code' => $value['excel_code'],
                'created_at' => now(),
                'updated_at' => now()
            ]);
        }

        $menu_type = MenuType::where('id', 9)->first();
        $menu_type->zone_menu_price = 1450;
        $menu_type->menu_type_id = 10;
        $menu_type->save();
    }
}
