<header class="">
    <div class="flex justify-between w-full p-5 text-white bg-black">
        <div class="flex items-center">
            <a class="" href="https://facebook.com/ettrend/" target="_blank">
                @include('components.facebook-icon')
            </a>
        </div>
        <div class="flex items-center animate-pulse">
            <span class="mr-2 material-symbols-outlined">
                info
            </span>
            <p>A rendelés felületünk megújult, a rendelés előtt regisztráció szükséges.</p>
        </div>
    </div>
    <nav class="flex items-center justify-between p-5 bg-gray-100">
        <a href="{{ route('home') }}">
            <img class="w-32 transition-all hover:scale-105" src="{{ asset('images/logo-black.png') }}" alt="Ét-trend" />
        </a>
        <div>
            {{-- mobile --}}
            <div x-data="{ open: false }" class="flex lg:hidden">
                <div>
                    <span @click="open=true" class="text-3xl material-symbols-outlined">
                        menu
                    </span>
                </div>
                <div x-show="open" class="absolute top-0 left-0 z-50 w-screen h-screen p-5 text-white bg-black">
                    <div class="flex items-center justify-between">
                        <a href="{{ route('home') }}">
                            <img class="w-32" src="{{ asset('images/logo-black.png') }}" alt="Ét-trend" />
                        </a>
                        <span @click="open=false" class="text-3xl material-symbols-outlined">
                            close
                        </span>
                    </div>
                    <div class="flex flex-col my-10">
                        <a class="my-2 text-3xl font-bold" href="{{ route('home') }}">{{ __('messages.home_page') }}</a>
                        <a class="my-2 text-3xl font-bold"
                            href="https://rendeles.ettrend.hu">{{ __('messages.order') }}</a>
                        <a class="my-2 text-3xl font-bold"
                            href="{{ route('contact') }}">{{ __('messages.contact') }}</a>
                    </div>
                </div>
            </div>
            {{-- pc --}}
            <div class="items-center hidden lg:flex">
                <a class="mx-2" href="{{ route('home') }}">{{ __('messages.home_page') }}</a>
                <a class="mx-2" href="https://rendeles.ettrend.hu">{{ __('messages.order') }}</a>
                <a class="mx-2" href="{{ route('contact') }}">{{ __('messages.contact') }}</a>
            </div>
        </div>
    </nav>
</header>
