<div class="my-5">
    @if (count($cartFoods) > 0)
        @foreach ($cartFoods as $item)
            <div class="bg-gray-50 my-5 rounded-[5px] p-3 md:w-1/2 mx-auto">
                @php
                    $food = App\Models\Food::where('id', $item->food_id)->first();
                    $menuType = App\Models\MenuType::where('id', $food->menu_type_id)->first();
                @endphp
                <div class="flex items-center justify-between">
                    <div class="">
                        <p class="text-sm font-semibold">{{ $food->name }}</p>
                        <div class="flex items-center">
                            <span class="mr-2 text-xs font-medium">{{$food->date}}</span>
                            <span class="mt-1 text-xs">{{ $menuType->name }}</span>
                        </div>
                    </div>
                    <div class="mx-3">
                        <span
                            wire:click="delete({{$item->id}})"
                            wire:loading.class="text-gray-500 animate-pulse"
                            class="cursor-pointer material-symbols-outlined">
                            delete
                        </span>
                    </div>
                </div>
                <div class="flex items-center justify-between mt-4">
                    <div class="flex items-center">
                        <div
                            class="w-5 h-5 bg-black text-white text-center rounded-[5px] flex justify-center items-center cursor-pointer"
                            wire:click="decrease({{$food->id}})"
                            wire:loading.class="bg-gray-500 animate-pulse">-</div>
                        <div class="w-5 h-5 border border-black rounded-[5px] flex justify-center items-center mx-1 text-sm">{{$item->quantity}}</div>
                        <div
                            class="w-5 h-5 bg-black text-white text-center rounded-[5px] flex justify-center items-center cursor-pointer"
                            wire:click="increase({{$food->id}})"
                            wire:loading.class="bg-gray-500 animate-pulse">+</div>
                        <span class="ml-2 text-xs text-gray-700">{{ $item->price }} Ft/adag</span>
                    </div>
                    <span class="font-bold">{{ $item->quantity * $item->price }} Ft</span>
                </div>
            </div>
        @endforeach
        <div class="flex flex-col items-end justify-end p-3 mx-auto my-3 md:w-1/2">
            @if ($total['quantity_discount'] > 0)
                <p>Étel ár: <span>{{ $total['food'] }} Ft</span></p>
                <p class="text-green-600 ">Mennyiségi kedvezmény: <span>{{ $total['quantity_discount'] }} Ft</span></p>
            @endif
            <p class="font-bold">Teljes ár: <span>{{ $total['total'] }} Ft</span></p>
        </div>
        <div class="flex flex-col items-end justify-end p-3 mx-auto my-3 md:w-1/2">
            <a class="px-4 py-2 text-white bg-black rounded-[5px]" href="{{route('checkout')}}">{{__('messages.checkout')}}</a>
        </div>
    @else
        <div class="flex flex-col items-center justify-center">
            <span class="mt-4 text-3xl text-gray-400 material-symbols-outlined">
                sentiment_dissatisfied
            </span>
            <p class="mb-4 text-lg text-gray-400">{{__('messages.empty_cart')}}</p>
            <div class="flex items-center justify-center">
                <a class="px-4 py-2 text-white bg-black rounded-[5px]" href="{{route('current_week_food')}}">{{__('messages.current_week_menu')}}</a>
                <a class="px-4 py-2 text-white bg-black rounded-[5px] ml-2" href="{{route('next_week_food')}}">{{__('messages.next_week_menu')}}</a>
            </div>
        </div>
    @endif
</div>
