<div class="">
    @if (session('success'))
        <div class="my-10">
            <div class="mx-auto w-[70px] h-[70px] rounded-full">
                <span class="text-6xl text-green-700 material-symbols-outlined animate-pulse">
                    check_circle
                </span>
            </div>
            <p class="text-xl font-bold text-center">Sikeresen elkülde az üzenet!</p>

            <div class="flex items-center justify-center w-full my-5">
                <a href="{{route('home')}}">
                    <div class="flex p-3 border border-black">
                        <span class="material-symbols-outlined">
                            home
                        </span>
                        <span class="ml-2 font-medium">Főoldal</span>
                    </div>
                </a>
            </div>
        </div>
    @else
        <form class="" wire:submit="create" action="">
            <div class="flex flex-col my-3">
                <label class="text-sm text-gray-700">Teljes név</label>
                @error('name')
                    <span class="text-xs text-red-500">{{ $message }}</span>
                @enderror
                <input
                    class="w-full rounded-[5px] border border-black text-sm mt-1 p-2"
                    wire:model="name"
                    type="text"
                    name="name"
                    id="name"
                    placeholder="Pingvin Endre"
                />
            </div>

            <div class="flex flex-col my-3">
                <label class="text-sm text-gray-700">Email</label>
                @error('email')
                    <span class="text-xs text-red-500">{{ $message }}</span>
                @enderror
                <input
                    class="w-full rounded-[5px] border border-black text-sm mt-1 p-2"
                    wire:model="email"
                    type="text"
                    name="email"
                    id="email"
                    placeholder="pingvin@email.hu"
                />
            </div>

            <div class="flex flex-col my-3">
                <label class="text-sm text-gray-700">Telefon</label>
                @error('phone')
                    <span class="text-xs text-red-500">{{ $message }}</span>
                @enderror
                <input
                    class="w-full rounded-[5px] border border-black text-sm mt-1 p-2"
                    wire:model="phone"
                    type="text"
                    name="phone"
                    id="phone"
                    placeholder="+36301112233"
                />
            </div>

            <div class="flex flex-col my-3">
                <label
                    class="text-sm text-gray-700"
                    for="body">Üzenet</label>
                @error('body')
                    <span class="text-xs text-red-500">{{ $message }}</span>
                @enderror
                <textarea
                    class="text-sm text-black border p-3 border-black h-[100px] rounded-[5px]"
                    wire:model="body"
                    name="body"
                    id="body"
                    placeholder="Írja meg kérdéseit. Rövid időn belül mindenre válaszolunk!"
                >
                </textarea>
            </div>

            <p class="my-3 text-sm">Az üzenet elküldésével elfogadja az Adatvédelmi tájékoztatóba foglaltakat!</p>

            <button
                    class="w-full rounded-[5px] border bg-black text-white border-black text-sm mt-1 p-2"
                    type="submit">
                    Küldés
                </button>
        </form>
    @endif
</div>
