<?php

use App\Http\Controllers\FoodController;
use App\Http\Controllers\LogoutController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\ProfileAddressController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\ProfileOrderController;
use App\Http\Controllers\SimplePayController;
use App\Http\Middleware\Maintenance;
use Illuminate\Support\Facades\Route;

Route::view('/karbantartas', 'maintenance')->name('maintenance');

Route::middleware(Maintenance::class)->group(function () {
    Route::view('/', 'home')->name('home');
    Route::view('/kapcsolat', 'contact')->name('contact');

    Route::redirect('/kosar', 'https://rendeles.ettrend.hu');
    Route::redirect('/penztar', 'https://rendeles.ettrend.hu');
    Route::redirect('/rendeles', 'https://rendeles.ettrend.hu');
    Route::redirect('/rendeles-jovohet', 'https://rendeles.ettrend.hu');
    Route::redirect('/sikeres-rendeles', '/page/sikeres-rendeles');

    Route::controller(PageController::class)->group(function () {
        Route::get('/page/{slug}', 'page')->name('page');
    });

    Route::controller(LogoutController::class)->group(function() {
        Route::get('/logout', 'logout')->name('logout');
    });
});
