<div x-data="{open: false}">
    <div
        class="fixed flex top-0 left-0 items-center justify-center w-screen h-screen bg-black/[.5]"
        x-show="open"
        x-init="window.Livewire.find('<?php echo e($_instance->getId()); ?>').on('added', () => { open = true; })"
    >
        <div
            class="flex flex-col items-center justify-center p-10 bg-white rounded"
            @click.outside="open = false"
        >
            <span class="mx-auto text-4xl text-green-600 material-symbols-outlined">check_circle</span>
            <p class="mt-2 text-lg font-bold text-center"><?php echo e($food->name); ?> <?php echo e(__('messages.added_to_cart')); ?>!</p>
            <p><?php echo e($food->date); ?> <span>(<?php echo e(__(Carbon\Carbon::create($food->date)->format('l'))); ?>)</span></p>
            <div class="flex items-center justify-center mt-2">
                <button
                    wire:click="decrease"
                    wire:loading.class='bg-gray-500 animate-pulse'
                    class="w-10 h-10 border rounded-[5px] bg-black text-white">-</button>
                <span class="w-10 h-10 border rounded-[5px]" type="number"><?php echo e($quantity); ?></span>
                <button
                    wire:click="increase"
                    wire:loading.class='bg-gray-500 animate-pulse'
                    class="w-10 h-10 border rounded-[5px] bg-black text-white">+</button>
            </div>
            <div class="my-3">
                <p class="text-sm">Egység ár: <span><?php echo e($food->price); ?> Ft</span></p>
                <p class="text-sm">Teljes ár: <span class="text-base font-bold"><?php echo e($food->price * $quantity); ?> Ft</span></p>
            </div>
            <div>
                <a class="px-4 py-2 text-white bg-black rounded-[3px] text-xs" href="<?php echo e(route('cart')); ?>">Kosár</a>
                <a class="px-4 py-2 text-white bg-black rounded-[3px] text-xs" href="<?php echo e(route('checkout')); ?>">Pénztár</a>
                <button class="px-4 py-2 text-white bg-black rounded-[3px] text-xs" @click="open=false">Folytatás</button>
            </div>
        </div>
    </div>
    <button
        class="px-3 py-1 text-xs text-white bg-black rounded-[3px]"
        wire:click='add'
        wire:loading.class='bg-gray-500 animate-pulse'
    ><?php echo e(__('messages.add_cart_text')); ?></button>
</div>
<?php /**PATH C:\app\ettrend_laravel\resources\views/livewire/add-cart-button.blade.php ENDPATH**/ ?>