<?php
    $orderId = $this->form->getRawState()['id'];
    $order = \App\Models\Order::find($orderId);
    $total = \App\Services\OrderService::getTotalPrice($order);
    //dd($total);
?>

<div class="flex flex-col items-start justify-start">
    <p class="my-2 text-sm"><span class="font-bold"><?php echo e(__('messages.foods_price')); ?></span> <span><?php echo e($total['food']); ?> Ft</span></p>
    <?php if($total['pack'] > 0): ?>
        <p class="my-2 text-sm"><span class="font-bold"><?php echo e(__('messages.pack_price')); ?></span> <span><?php echo e($total['pack']); ?> Ft</span></p>
    <?php endif; ?>
    <?php if($total['delivery'] > 0): ?>
        <p class="my-2 text-sm"><span class="font-bold"><?php echo e(__('messages.delivery_price')); ?></span> <span><?php echo e($total['delivery']); ?> Ft</span></p>
    <?php endif; ?>
    <?php if($total['payment'] > 0): ?>
        <p class="my-2 text-sm"><span class="font-bold"><?php echo e(__('messages.payment_price')); ?></span> <span><?php echo e($total['payment']); ?> Ft</span></p>
    <?php endif; ?>
    <?php if($total['quantity_discount'] > 0): ?>
        <p class="my-2 text-sm"><span class="font-bold"><?php echo e(__('messages.quantity_discount')); ?></span> <span class="text-green-800">-<?php echo e($total['quantity_discount']); ?> Ft</span></p>
    <?php endif; ?>
    <?php if($total['coupon'] > 0): ?>
        <p class="my-2 text-sm"><span class="font-bold"><?php echo e(__('messages.coupon_price')); ?></span> <span class="text-green-800">-<?php echo e($total['coupon']); ?> Ft</span></p>
    <?php endif; ?> <!-- __ENDBLOCK__ -->
    <p class="mt-3 font-bold">Teljes ár: <span><?php echo e($total['total']); ?> Ft</span></p>
</div><?php /**PATH C:\app\ettrend_laravel\resources\views/components/admin-order-item-total.blade.php ENDPATH**/ ?>