<div class="flex flex-col w-full">
    <?php if(count($addresses) > 0): ?>
        <div class="relative overflow-x-auto sm:rounded-lg">
            <table class="w-full text-sm text-left text-gray-700">
                <thead class="text-xs text-gray-800 uppercase bg-gray-50">
                    <tr>
                        <th scope="col" class="px-6 py-3">
                            <?php echo e(__('messages.country')); ?>

                        </th>
                        <th scope="col" class="px-6 py-3">
                            <?php echo e(__('messages.zip')); ?>

                        </th>
                        <th scope="col" class="px-6 py-3">
                            <?php echo e(__('messages.city')); ?>

                        </th>
                        <th scope="col" class="px-6 py-3">
                            <?php echo e(__('messages.address')); ?>

                        </th>
                        <th scope="col" class="px-6 py-3">
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <!-- __BLOCK__ --><?php $__currentLoopData = $addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="bg-white border-b">
                            <th scope="row" class="px-6 py-4 font-medium text-gray-900 whitespace-nowrap">
                                <?php echo e($item->country); ?>

                            </th>
                            <td class="px-6 py-4">
                                <?php echo e($item->zip); ?>

                            </td>
                            <td class="px-6 py-4">
                                <?php echo e($item->city); ?>

                            </td>
                            <td class="px-6 py-4 min-w-[250px]">
                                <?php echo e($item->address); ?>

                            </td>
                            <td class="px-6 py-4">
                                <a href="<?php echo e(route('profile_address_item', ['id' => $item->id])); ?>" class="font-medium text-black hover:underline">
                                    <span class="material-symbols-outlined">
                                        edit
                                    </span>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!-- __ENDBLOCK__ -->
                </tbody>
                <tfoot class="text-xs text-gray-800 bg-gray-50">
                    <tr>
                        <td class="pl-3">
                            <div class="flex items-center my-3">
                                <select
                                    id="per_page"
                                    wire:model.live="perPage"
                                    class="text-xs py-1 px-5 rounded-[5px] mr-2">
                                    <option value="5">5</option>
                                    <option value="10">10</option>
                                    <option value="15">15</option>
                                    <option value="25">25</option>
                                </select>
                                <label for="per_page" class="text-sm text-gray-500"><?php echo e(__('messages.per_page')); ?></label>
                            </div>
                        </td>
                        <td class="pr-3" colspan="4">
                            <div class="flex items-center justify-end">
                                <?php echo e($addresses->links()); ?>

                            </div>
                        </td>
                    </tr>
                </tfoot>
            </table>
        </div>
    <?php else: ?>
        <p><?php echo e(__('messages.not_have_address')); ?></p>
    <?php endif; ?> <!-- __ENDBLOCK__ -->
</div>
<?php /**PATH C:\app\ettrend_laravel\resources\views/livewire/address-list.blade.php ENDPATH**/ ?>