<!-- __BLOCK__ --><?php if($order == null): ?>
    <!-- __BLOCK__ --><?php if($my_redirect): ?>
        <div class="items-center justify-center w-full mx-auto my-5 text-center animate-pulse text-xsflex md:w-1/2">
            <div class="flex flex-col items-center justify-center">
                <span class="text-yellow-300 material-symbols-outlined">
                    directions_alt
                </span>
                <span class="ml-1">átirányítás..</span>
            </div>
        </div>
    <?php else: ?>
        <div class="p-5 md:w-1/2 md:mx-auto">
            <span class="my-5 text-6xl text-red-600 material-symbols-outlined">
                warning
            </span>
            <h1 class="mb-3 text-2xl font-bold">Hiba a rendelás azonosítása során.</h1>
            <p>Amennyiben nem kapta meg a rendelés visszaigazoló email-t a megadott email címre, kérjük vegye fel velünk a kapcsolatot.</p>
            <p class="mt-5"><span class="font-bold">Kapcsolat ürlap:</span> <a class="underline" href="<?php echo e(route('contact')); ?>">itt</a></p>
            <p class="mt-2"><span class="font-bold">Email:</span> <a class="underline" href="mailto:info.ettrend@gmail.com">info.ettrend@email.com</a></p>
            <div class="mt-10">
                <a class="py-3 px-5 bg-black text-white rounded-[5px]" href="<?php echo e(route('home')); ?>">Főoldal</a>
            </div>
        </div>
    <?php endif; ?> <!-- __ENDBLOCK__ -->
<?php else: ?>
    <div class="p-5 md:w-1/2 md:mx-auto">
        <div class="flex items-center justify-between w-full">
            <div class="flex items-center">
                <a href="<?php echo e(route('home')); ?>">
                    <span class="text-2xl material-symbols-outlined">
                        home
                    </span>
                </a>
                <!-- __BLOCK__ --><?php if(auth()->guard()->check()): ?>
                    <a href="<?php echo e(route('profile_order')); ?>">
                        <span class="ml-4 text-2xl material-symbols-outlined">
                            list_alt
                        </span>
                    </a>
                <?php endif; ?> <!-- __ENDBLOCK__ -->
            </div>
            <a href="<?php echo e(route('home')); ?>">
                <img class="w-20 md:w-32" src="<?php echo e(asset('images/logo-black.png')); ?>" alt="Ét-trend" />
            </a>
        </div>
        <div class="flex items-center justify-center mx-auto">
            <span class="mx-auto text-4xl text-green-700 material-symbols-outlined">
                check_circle
            </span>
        </div>
        <h1 class="my-5 text-2xl font-bold text-center md:ml-0"><?php echo e(__('messages.success_order')); ?></h1>
        <p class="text-center">A rendelési azonosítója <span class="font-bold">#<?php echo e($order->id); ?></span></p>
        <p class="my-2 text-sm text-center">A rendelés megerősítő email-t a/az <span class="font-bold"><?php echo e($order->email); ?></span> email címen tekintheti meg.</p>

        <!-- __BLOCK__ --><?php if(auth()->guard()->guest()): ?>
            <div>
                <p class="mb-5 text-center">Amennyiben szeretné rendeléseit vissza nézni. Hozzon létre profilt a következő gombra kattintva. <a class="underline" href="<?php echo e(route('filament.admin.auth.register')); ?>">Regisztráció</a></p>
            </div>
        <?php endif; ?> <!-- __ENDBLOCK__ -->

        <div class="flex flex-col my-2">
            <div class="py-5">
                <p class="mb-2 font-bold">Rendelési adatok:</p>
                <p class="text-sm"><span class="font-bold"><?php echo e(__('messages.fullname')); ?>:</span> <span><?php echo e($order->fullname); ?></span></p>
                <p class="text-sm"><span class="font-bold"><?php echo e(__('messages.email')); ?>:</span> <span><?php echo e($order->email); ?></span></p>
                <p class="text-sm"><span class="font-bold"><?php echo e(__('messages.phone')); ?>:</span> <span><?php echo e($order->phone); ?></span></p>
            </div>
            <div class="py-5">
                <p class="mb-2 font-bold">Szállítási adatok:</p>
                <p class="text-sm"><span class="font-bold"><?php echo e(__('messages.delivery_country')); ?>:</span> <span><?php echo e($order->delivery_country); ?></span></p>
                <p class="text-sm"><span class="font-bold"><?php echo e(__('messages.delivery_zip')); ?>:</span> <span><?php echo e($order->delivery_zip); ?></span></p>
                <p class="text-sm"><span class="font-bold"><?php echo e(__('messages.delivery_city')); ?>:</span> <span><?php echo e($order->delivery_city); ?></span></p>
                <p class="text-sm"><span class="font-bold"><?php echo e(__('messages.delivery_address')); ?>:</span> <span><?php echo e($order->delivery_address); ?></span></p>
            </div>

            <div class="py-5">
                <p class="mb-2 font-bold">Fizetési adatok:</p>
                <p class="text-sm"><span class="font-bold"><?php echo e(__('messages.payment')); ?>:</span> <span><?php echo e($payment->name); ?></span></p>
            </div>

            <!-- __BLOCK__ --><?php if($coupon != null): ?>
                <div class="py-5">
                    <p class="mb-2 font-bold"><?php echo e(__('messages.coupon')); ?>:</p>
                    <p class="text-sm"><span class="font-bold"><?php echo e(__('messages.coupon_code')); ?>:</span> <span><?php echo e($coupon->code); ?></span></p>
                    <p class="text-sm"><span class="font-bold"><?php echo e(__('messages.coupon_discount')); ?>:</span> <span>-<?php echo e($coupon->value); ?></span> Ft</p>
                </div>
            <?php endif; ?> <!-- __ENDBLOCK__ -->

            <!-- __BLOCK__ --><?php if($order->invoice_name): ?>
                <div class="py-5">
                    <p class="mb-2 font-bold">Számlázási adatok:</p>
                    <p class="text-sm"><span class="font-bold"><?php echo e(__('messages.invoice_name')); ?>:</span> <span><?php echo e($order->invoice_name); ?></span></p>
                    <p class="text-sm"><span class="font-bold"><?php echo e(__('messages.invoice_tax')); ?>:</span> <span><?php echo e($order->invoice_tax); ?></span></p>
                    <p class="text-sm"><span class="font-bold"><?php echo e(__('messages.invoice_country')); ?>:</span> <span><?php echo e($order->invoice_country); ?></span></p>
                    <p class="text-sm"><span class="font-bold"><?php echo e(__('messages.invoice_zip')); ?>:</span> <span><?php echo e($order->invoice_zip); ?></span></p>
                    <p class="text-sm"><span class="font-bold"><?php echo e(__('messages.invoice_city')); ?>:</span> <span><?php echo e($order->invoice_city); ?></span></p>
                    <p class="text-sm"><span class="font-bold"><?php echo e(__('messages.invoice_address')); ?>:</span> <span><?php echo e($order->invoice_address); ?></span></p>
                </div>
            <?php endif; ?> <!-- __ENDBLOCK__ -->
        </div>

        <div class="p-5 bg-gray-100">
            <p class="font-bold"><?php echo e(__('messages.products')); ?></p>
            <div class="md:overflow-y-auto md:h-1/3 lg:h-2/3">
                <!-- __BLOCK__ --><?php $__currentLoopData = $orderFoods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="bg-white my-5 rounded-[5px] p-3 mx-auto">
                        <?php
                            $food = App\Models\Food::where('id', $item->food_id)->first();
                            $menuType = App\Models\MenuType::where('id', $food->menu_type_id)->first();
                        ?>
                        <div class="flex items-center justify-between">
                            <div class="">
                                <p class="text-sm font-semibold"><?php echo e($food->name); ?></p>
                                <div class="flex items-center">
                                    <span class="mr-2 text-xs font-medium"><?php echo e($food->date); ?></span>
                                    <span class="mt-1 text-xs"><?php echo e($menuType->name); ?></span>
                                </div>
                            </div>
                            <div class="mx-3">
                                <span class="ml-2 text-xs text-gray-700"><?php echo e($item->quantity); ?> adag</span>
                            </div>
                        </div>
                        <div class="flex items-center justify-between mt-4">
                            <div class="flex items-center">
                                <span class="ml-2 text-xs text-gray-700"><?php echo e($item->price); ?> Ft/adag</span>
                            </div>
                            <span class="font-bold"><?php echo e($item->quantity * $item->price); ?> Ft</span>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!-- __ENDBLOCK__ -->
            </div>
            <div class="my-5">
                <p class="my-1 text-sm"><span class="font-bold"><?php echo e(__('messages.foods_price')); ?></span> <span><?php echo e($total['food']); ?> Ft</span></p>
                <?php if($total['pack'] > 0): ?>
                    <p class="my-1 text-sm"><span class="font-bold"><?php echo e(__('messages.pack_price')); ?></span> <span><?php echo e($total['pack']); ?> Ft</span></p>
                <?php endif; ?>
                <?php if($total['delivery'] > 0): ?>
                    <p class="my-1 text-sm"><span class="font-bold"><?php echo e(__('messages.delivery_price')); ?></span> <span><?php echo e($total['delivery']); ?> Ft</span></p>
                <?php endif; ?>
                <?php if($total['payment'] > 0): ?>
                    <p class="my-1 text-sm"><span class="font-bold"><?php echo e(__('messages.payment_price')); ?></span> <span><?php echo e($total['payment']); ?> Ft</span></p>
                <?php endif; ?>
                <?php if($total['quantity_discount'] > 0): ?>
                    <p class="my-1 text-sm"><span class="font-bold"><?php echo e(__('messages.quantity_discount')); ?></span> <span class="text-green-800">-<?php echo e($total['quantity_discount']); ?> Ft</span></p>
                <?php endif; ?>
                <?php if($total['coupon'] > 0): ?>
                    <p class="my-1 text-sm"><span class="font-bold"><?php echo e(__('messages.coupon_price')); ?></span> <span class="text-green-800">-<?php echo e($total['coupon']); ?> Ft</span></p>
                <?php endif; ?> <!-- __ENDBLOCK__ -->
                <p class="mt-2 font-bold">Teljes ár: <span><?php echo e($total['total']); ?> Ft</span></p>
            </div>
            <div class="flex items-center">
                <a class="my-1 mr-3 text-xs text-gray-300" href="<?php echo e(route('home')); ?>" target="_blank">Adatvédelmi tájékoztató</a>
                <a class="my-1 text-xs text-gray-300" href="https://simplepartner.hu/PaymentService/Fizetesi_tajekoztato.pdf" target="_blank">Simplepay fizetési tájékoztató</a>
            </div>
        </div>
    </div>
<?php endif; ?> <!-- __ENDBLOCK__ -->
<?php /**PATH /cphome/rh31796/public_html/ettrend.hu/resources/views/livewire/success-order.blade.php ENDPATH**/ ?>