<div class="bg-gray-100 my-5 rounded-[5px] p-3 md:w-1/2 mx-auto">
    <?php
        $menuType = App\Models\MenuType::where('id', $food->menu_type_id)->first();
    ?>
    <div class="flex items-center justify-between">
        <div class="">
            <p class="text-sm font-semibold"><?php echo e($food->name); ?></p>
            <div class="flex items-center">
                <span class="mr-2 text-xs font-medium"><?php echo e($food->date); ?></span>
                <span class="mt-1 text-xs"><?php echo e($menuType->name); ?></span>
            </div>
        </div>
        <div class="mx-3">
            <span
                wire:click="delete"
                wire:loading.class="text-gray-500 animate-pulse"
                class="cursor-pointer material-symbols-outlined">
                delete
            </span>
        </div>
    </div>
    <div class="flex items-center justify-between mt-4">
        <div class="flex items-center">
            <div
                class="w-5 h-5 bg-black text-white text-center rounded-[5px] flex justify-center items-center cursor-pointer"
                wire:click="decrease"
                wire:loading.class="bg-gray-500 animate-pulse">-</div>
            <div class="w-5 h-5 border border-black rounded-[5px] flex justify-center items-center mx-1 text-sm"><?php echo e($cartFood->quantity); ?></div>
            <div
                class="w-5 h-5 bg-black text-white text-center rounded-[5px] flex justify-center items-center cursor-pointer"
                wire:click="increase"
                wire:loading.class="bg-gray-500 animate-pulse">+</div>
            <span class="ml-2 text-xs text-gray-700"><?php echo e($cartFood->price); ?> Ft/adag</span>
        </div>
        <span class="font-bold"><?php echo e($cartFood->quantity * $cartFood->price); ?> Ft</span>
    </div>
</div>
<?php /**PATH C:\app\ettrend_laravel\resources\views/livewire/cart-item.blade.php ENDPATH**/ ?>