<header class="">
    <div class="flex justify-between w-full p-5 text-white bg-black">
        <div class="flex items-center">
            <a class="" href="https://facebook.com/ettrend/" target="_blank">
                <?php echo $__env->make('components.facebook-icon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </a>
        </div>
        <div class="flex items-center animate-pulse">
            <span class="mr-2 material-symbols-outlined">
                info
            </span>
            <p>A rendelés felületünk megújult, a rendelés előtt regisztráció szükséges.</p>
        </div>
    </div>
    <nav class="flex items-center justify-between p-5 bg-gray-100">
        <a href="<?php echo e(route('home')); ?>">
            <img class="w-32 transition-all hover:scale-105" src="<?php echo e(asset('images/logo-black.png')); ?>" alt="Ét-trend" />
        </a>
        <div>
            
            <div x-data="{ open: false }" class="flex lg:hidden">
                <div>
                    <span @click="open=true" class="text-3xl material-symbols-outlined">
                        menu
                    </span>
                </div>
                <div x-show="open" class="absolute top-0 left-0 z-50 w-screen h-screen p-5 text-white bg-black">
                    <div class="flex items-center justify-between">
                        <a href="<?php echo e(route('home')); ?>">
                            <img class="w-32" src="<?php echo e(asset('images/logo-black.png')); ?>" alt="Ét-trend" />
                        </a>
                        <span @click="open=false" class="text-3xl material-symbols-outlined">
                            close
                        </span>
                    </div>
                    <div class="flex flex-col my-10">
                        <a class="my-2 text-3xl font-bold" href="<?php echo e(route('home')); ?>"><?php echo e(__('messages.home_page')); ?></a>
                        <a class="my-2 text-3xl font-bold"
                            href="https://rendeles.ettrend.hu"><?php echo e(__('messages.order')); ?></a>
                        <a class="my-2 text-3xl font-bold"
                            href="<?php echo e(route('contact')); ?>"><?php echo e(__('messages.contact')); ?></a>
                    </div>
                </div>
            </div>
            
            <div class="items-center hidden lg:flex">
                <a class="mx-2" href="<?php echo e(route('home')); ?>"><?php echo e(__('messages.home_page')); ?></a>
                <a class="mx-2" href="https://rendeles.ettrend.hu"><?php echo e(__('messages.order')); ?></a>
                <a class="mx-2" href="<?php echo e(route('contact')); ?>"><?php echo e(__('messages.contact')); ?></a>
            </div>
        </div>
    </nav>
</header>
<?php /**PATH /cphome/rh31796/public_html/ettrend.hu/resources/views/components/header.blade.php ENDPATH**/ ?>