<header class="">
    <div class="flex justify-between w-full p-5 text-white bg-black">
        <div class="flex items-center">
            <a class="" href="https://facebook.com/ettrend/" target="_blank">
                <?php echo $__env->make('components.facebook-icon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </a>
        </div>
        <div>
            <?php if(auth()->guard()->check()): ?>
                <?php if(auth()->user()->role == 'root' || auth()->user()->role == 'admin'): ?>
                    <a href="<?php echo e(route('filament.admin.pages.dashboard')); ?>">
                        <span class="mr-2 material-symbols-outlined">
                            dashboard
                        </span>
                    </a>
                <?php endif; ?>
                <a href="<?php echo e(route('profile')); ?>">
                    <span class="mr-2 material-symbols-outlined">
                        person
                    </span>
                </a>
                <a href="<?php echo e(route('logout')); ?>">
                    <span class="material-symbols-outlined">
                        logout
                    </span>
                </a>
            <?php endif; ?>
            <?php if(auth()->guard()->guest()): ?>
                <a href="<?php echo e(route('filament.admin.auth.login')); ?>">
                    <span class="material-symbols-outlined">
                        login
                    </span>
                </a>
            <?php endif; ?>
        </div>
    </div>
    <nav class="flex items-center justify-between p-5 bg-gray-100">
        <a href="<?php echo e(route('home')); ?>">
            <img class="w-32 transition-all hover:scale-105" src="<?php echo e(asset('images/logo-black-christmas.png')); ?>" alt="Ét-trend" />
        </a>
        <div>
            
            <div
                x-data="{ open:false }"
                class="flex lg:hidden">
                <div>
                    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('cart-button', []);

$__html = app('livewire')->mount($__name, $__params, '9u6qiF3', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <span @click="open=true"
                        class="text-3xl material-symbols-outlined">
                        menu
                    </span>
                </div>
                <div x-show="open"
                    class="absolute top-0 left-0 z-50 w-screen h-screen p-5 text-white bg-black">
                    <div class="flex items-center justify-between">
                        <a href="<?php echo e(route('home')); ?>">
                            <img class="w-32" src="<?php echo e(asset('images/logo-black.png')); ?>" alt="Ét-trend" />
                        </a>
                        <span @click="open=false"
                            class="text-3xl material-symbols-outlined">
                            close
                        </span>
                    </div>
                    <div class="flex flex-col my-10">
                        <a class="my-2 text-3xl font-bold" href="<?php echo e(route('home')); ?>"><?php echo e(__('messages.home_page')); ?></a>
                        <a class="my-2 text-3xl font-bold" href="<?php echo e(route('current_week_food')); ?>"><?php echo e(__('messages.current_week_menu')); ?></a>
                        <a class="my-2 text-3xl font-bold" href="<?php echo e(route('next_week_food')); ?>"><?php echo e(__('messages.next_week_menu')); ?></a>
                        <a class="my-2 text-3xl font-bold" href="<?php echo e(route('contact')); ?>"><?php echo e(__('messages.contact')); ?></a>
                    </div>
                </div>
            </div>
            
            <div class="items-center hidden lg:flex">
                <a class="mx-2" href="<?php echo e(route('home')); ?>"><?php echo e(__('messages.home_page')); ?></a>
                <div x-data="{ open:false }">
                    <div @click="open=true" class="cursor-pointer"><?php echo e(__('messages.order')); ?></div>
                    <div x-show="open"
                         @click.outside="open = false"
                         class="absolute z-50 flex flex-col p-3 bg-white shadow-sm rounded-[5px]">
                        <a class="mx-2 my-1" href="<?php echo e(route('current_week_food')); ?>"><?php echo e(__('messages.current_week_menu')); ?></a>
                        <a class="mx-2 my-1" href="<?php echo e(route('next_week_food')); ?>"><?php echo e(__('messages.next_week_menu')); ?></a>
                    </div>
                </div>
                <a class="mx-2" href="<?php echo e(route('contact')); ?>"><?php echo e(__('messages.contact')); ?></a>
                <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('cart-button', []);

$__html = app('livewire')->mount($__name, $__params, 'dpJFiDB', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
            </div>
        </div>
    </nav>
</header>
<?php /**PATH C:\app\ettrend_laravel\resources\views/components/header.blade.php ENDPATH**/ ?>