<div class="my-5">
    <?php if(count($cartFoods) > 0): ?>
        <!-- __BLOCK__ --><?php $__currentLoopData = $cartFoods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="bg-gray-50 my-5 rounded-[5px] p-3 md:w-1/2 mx-auto">
                <?php
                    $food = App\Models\Food::where('id', $item->food_id)->first();
                    $menuType = App\Models\MenuType::where('id', $food->menu_type_id)->first();
                ?>
                <div class="flex items-center justify-between">
                    <div class="">
                        <p class="text-sm font-semibold"><?php echo e($food->name); ?></p>
                        <div class="flex items-center">
                            <span class="mr-2 text-xs font-medium"><?php echo e($food->date); ?></span>
                            <span class="mt-1 text-xs"><?php echo e($menuType->name); ?></span>
                        </div>
                    </div>
                    <div class="mx-3">
                        <span
                            wire:click="delete(<?php echo e($item->id); ?>)"
                            wire:loading.class="text-gray-500 animate-pulse"
                            class="cursor-pointer material-symbols-outlined">
                            delete
                        </span>
                    </div>
                </div>
                <div class="flex items-center justify-between mt-4">
                    <div class="flex items-center">
                        <div
                            class="w-5 h-5 bg-black text-white text-center rounded-[5px] flex justify-center items-center cursor-pointer"
                            wire:click="decrease(<?php echo e($food->id); ?>)"
                            wire:loading.class="bg-gray-500 animate-pulse">-</div>
                        <div class="w-5 h-5 border border-black rounded-[5px] flex justify-center items-center mx-1 text-sm"><?php echo e($item->quantity); ?></div>
                        <div
                            class="w-5 h-5 bg-black text-white text-center rounded-[5px] flex justify-center items-center cursor-pointer"
                            wire:click="increase(<?php echo e($food->id); ?>)"
                            wire:loading.class="bg-gray-500 animate-pulse">+</div>
                        <span class="ml-2 text-xs text-gray-700"><?php echo e($item->price); ?> Ft/adag</span>
                    </div>
                    <span class="font-bold"><?php echo e($item->quantity * $item->price); ?> Ft</span>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!-- __ENDBLOCK__ -->
        <div class="flex flex-col items-end justify-end p-3 mx-auto my-3 md:w-1/2">
            <?php if($total['quantity_discount'] > 0): ?>
                <p>Étel ár: <span><?php echo e($total['food']); ?> Ft</span></p>
                <p class="text-green-600 ">Mennyiségi kedvezmény: <span><?php echo e($total['quantity_discount']); ?> Ft</span></p>
            <?php endif; ?> <!-- __ENDBLOCK__ -->
            <p class="font-bold">Teljes ár: <span><?php echo e($total['total']); ?> Ft</span></p>
        </div>
        <div class="flex flex-col items-end justify-end p-3 mx-auto my-3 md:w-1/2">
            <a class="px-4 py-2 text-white bg-black rounded-[5px]" href="<?php echo e(route('checkout')); ?>"><?php echo e(__('messages.checkout')); ?></a>
        </div>
    <?php else: ?>
        <div class="flex flex-col items-center justify-center">
            <span class="mt-4 text-3xl text-gray-400 material-symbols-outlined">
                sentiment_dissatisfied
            </span>
            <p class="mb-4 text-lg text-gray-400"><?php echo e(__('messages.empty_cart')); ?></p>
            <div class="flex items-center justify-center">
                <a class="px-4 py-2 text-white bg-black rounded-[5px]" href="<?php echo e(route('current_week_food')); ?>"><?php echo e(__('messages.current_week_menu')); ?></a>
                <a class="px-4 py-2 text-white bg-black rounded-[5px] ml-2" href="<?php echo e(route('next_week_food')); ?>"><?php echo e(__('messages.next_week_menu')); ?></a>
            </div>
        </div>
    <?php endif; ?> <!-- __ENDBLOCK__ -->
</div>
<?php /**PATH /cphome/rh31796/public_html/ettrend.hu/resources/views/livewire/cart.blade.php ENDPATH**/ ?>