<?php
    $submit_disabled = false;
?>
<div class="flex flex-col-reverse w-full md:flex-row-reverse">
    <div class="p-5 bg-white md:w-1/2">
        <!-- __BLOCK__ --><?php if($payment_canceled): ?>
            <div
                class="p-5 mx-auto my-10 text-center border border-red-300 rounded-[5px] lg:w-1/2 bg-red-100 flex justify-between items-center"
                x-data="{ open: true }"
                x-show="open">
                <div class="flex items-center">
                    <span class="text-red-400 material-symbols-outlined animate-pulse">
                        warning
                    </span>
                    <div class="ml-3 text-left">
                        <p class="text-sm text-red-400">Fizetés megszakítva.</p>
                        <p class="text-xs text-red-300">A rendeléséhez új azonosító generálódik.</p>
                    </div>
                </div>
                <span
                    @click="open=false"
                    class="text-red-400 cursor-pointer material-symbols-outlined">
                    close
                </span>
            </div>
        <?php endif; ?> <!-- __ENDBLOCK__ -->
        <form class="mx-auto lg:w-1/2" wire:submit="create">
            <p class="font-bold">Rendelői adatok:</p>
            <div class="my-3">
                <label
                    class="text-xs text-gray-400"
                    for="fullname"
                ><?php echo e(__('messages.fullname')); ?></label>
                <input
                    id="fullname"
                    name="fullname"
                    type="text"
                    wire:model="fullname"
                    placeholder="Pingvin János"
                    class="w-full rounded-[5px] border border-black text-sm mt-1 p-2"
                    required />
            </div>

            <div class="my-3">
                <label
                    class="text-xs text-gray-400"
                    for="email"
                ><?php echo e(__('messages.email')); ?></label>
                <input
                    id="email"
                    name="email"
                    type="email"
                    wire:model.live="email"
                    placeholder="pingvin@gml.hu"
                    class="w-full rounded-[5px] border border-black text-sm mt-1 p-2"
                    required />
                <!-- __BLOCK__ --><?php if($email_exist): ?>
                    <div
                        x-data="{ open: true }"
                        class="p-3 border mt-3 rounded-[5px]"
                        x-show="open">
                        <div class="flex items-center justify-between">
                            <span class="text-gray-500 material-symbols-outlined">
                                info
                            </span>

                            <span
                                @click="open=false"
                                class="text-gray-500 cursor-pointer material-symbols-outlined">
                                close
                            </span>
                        </div>
                        <p class="mt-2 text-xs text-gray-500">Ehhez emailhez tartozik profil. Lépjen be, hogy a rendelés bekerüljön az adott profil rendeléseihez.</p>
                        <a class="my-1 text-xs text-gray-500 underline" href="<?php echo e(route('filament.admin.auth.login')); ?>">Belépés</a>
                    </div>
                <?php endif; ?> <!-- __ENDBLOCK__ -->
            </div>

            <div class="my-3">
                <label
                    class="text-xs text-gray-400"
                    for="phone"
                ><?php echo e(__('messages.phone')); ?></label>
                <input
                    id="phone"
                    name="phone"
                    type="phone"
                    wire:model="phone"
                    placeholder="+36301112233"
                    class="w-full rounded-[5px] border border-black text-sm mt-1 p-2"
                    required />
            </div>

            
            <p class="mt-6 font-bold">Szállítási adatok:</p>
            <?php if(count($delivery_addresses) > 0): ?>
                <div class="my-3">
                    <label
                        class="text-xs text-gray-400"
                        for="select_delivery_address"
                    ><?php echo e(__('messages.delivery_address')); ?></label>
                    <select
                        class="w-full rounded-[5px] border border-black text-sm mt-1 p-2"
                        wire:model.live="selected_delivery_address"
                        required>
                        <option value="" selected disabled><?php echo e(__('messages.choose_delivery_address')); ?></option>
                        <!-- __BLOCK__ --><?php $__currentLoopData = $delivery_addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($item->id); ?>"><?php echo e($item->country .' '.$item->zip.' '.$item->city.', '.$item->address); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!-- __ENDBLOCK__ -->
                    </select>
                    <?php
                        $zip = App\Models\Zip::where('zip', $delivery_zip)->first();
                        //dd($delivery_zip);
                    ?>
                    <!-- __BLOCK__ --><?php if($zip != null): ?>
                        <p class="mt-1 text-xs font-bold text-green-500">+<?php echo e($zip->price); ?> Ft <span class="font-normal">Szállítási költség.</span></p>
                    <?php endif; ?> <!-- __ENDBLOCK__ -->
                </div>
            <?php else: ?>
                <div class="my-3">
                    <label
                        class="text-xs text-gray-400"
                        for="delivery_country"
                    ><?php echo e(__('messages.delivery_country')); ?></label>
                    <input
                        id="delivery_country"
                        name="delivery_country"
                        type="text"
                        wire:model="delivery_country"
                        placeholder="Magyarország"
                        class="w-full rounded-[5px] border border-black text-sm mt-1 p-2"
                        disabled />
                </div>

                <div class="my-3">
                    <label
                        class="text-xs text-gray-400"
                        for="delivery_zip"
                    ><?php echo e(__('messages.delivery_zip')); ?></label>
                    <input
                        id="delivery_zip"
                        name="delivery_zip"
                        type="text"
                        wire:model.live="delivery_zip"
                        placeholder="6721"
                        class="w-full rounded-[5px] border border-black text-sm mt-1 p-2"
                        required />
                    <?php
                        $zip = App\Models\Zip::where('zip', $delivery_zip)->first();
                    ?>
                    <!-- __BLOCK__ --><?php if($zip != null): ?>
                        <p class="mt-1 text-xs font-bold text-green-500">+<?php echo e($zip->price); ?> Ft <span class="font-normal">Szállítási költség.</span></p>
                    <?php endif; ?> <!-- __ENDBLOCK__ -->
                    <!-- __BLOCK__ --><?php if($delivery_zip != null): ?>
                        <!-- __BLOCK__ --><?php if($delivery_zip < $zip_min || $delivery_zip > $zip_max): ?>
                            <?php
                                $submit_disabled = true;
                            ?>
                            <p class="mt-1 text-xs font-bold text-red-500">Nincs kiszállítás a megadott irányítószámra.</p>
                        <?php endif; ?> <!-- __ENDBLOCK__ -->
                    <?php endif; ?> <!-- __ENDBLOCK__ -->
                </div>

                <div class="my-3">
                    <label
                        class="text-xs text-gray-400"
                        for="delivery_city"
                    ><?php echo e(__('messages.delivery_city')); ?></label>
                    <input
                        id="delivery_city"
                        name="delivery_city"
                        type="text"
                        wire:model.live="delivery_city"
                        placeholder="Szeged"
                        class="w-full rounded-[5px] border border-black text-sm mt-1 p-2"
                        required />
                </div>

                <div class="my-3">
                    <label
                        class="text-xs text-gray-400"
                        for="delivery_address"
                    ><?php echo e(__('messages.delivery_address')); ?></label>
                    <input
                        id="delivery_address"
                        name="delivery_address"
                        type="text"
                        wire:model="delivery_address"
                        placeholder="Szegedi utca 11 2 em. 5b a."
                        class="w-full rounded-[5px] border border-black text-sm mt-1 p-2"
                        required />
                </div>
            <?php endif; ?> <!-- __ENDBLOCK__ -->

            
            <div class="my-3">
                <label
                    class="text-xs text-gray-400"
                    for="delivery_city"
                ><?php echo e(__('messages.comment')); ?></label>
                <textarea
                    id="comment"
                    name="comment"
                    type="text"
                    wire:model="comment"
                    placeholder="Megjegyzés a futárnak."
                    class="w-full rounded-[5px] border border-black text-sm mt-1 p-2"></textarea>
            </div>

            
            <div class="my-3">
                <p class="mt-3 font-bold">Fizetési mód:</p>
                <!-- __BLOCK__ --><?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div
                    x-data="{ open: false }"
                    class="my-5">
                    <div
                        class="flex items-center my-3"
                        @click="open = true"
                        @click.outside="open = false">
                        <input
                            id="payment-<?php echo e($payment->slug); ?>"
                            type="radio"
                            name="payment"
                            wire:model.live="payment"
                            value="<?php echo e($payment->slug); ?>"
                        />
                        <div class="flex items-center ml-2">
                            <label
                                for="payment-<?php echo e($payment->slug); ?>"
                                class="text-sm"><?php echo e($payment->name); ?></label>
                            <?php if($payment->price > 0): ?>
                                <div class="p-1 ml-2 text-xs text-green-700 bg-green-300 rounded">+ <?php echo e($payment->price); ?> Ft</div>
                            <?php endif; ?> <!-- __ENDBLOCK__ -->
                        </div>
                    </div>
                    <div
                        x-show="open"
                        class="p-5 bg-white rounded-[5px]">
                        <p class="text-xs"><?php echo e($payment->description); ?></p>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!-- __ENDBLOCK__ -->
            </div>

            
            <div
                class="my-3"
                x-data="{ open: false }">
                <div x-show="!open">
                    <span class="mr-1 text-sm">Szeretne számlát a rendelésről?</span>
                    <span class="text-sm font-bold cursor-pointer" @click="open=!open">Igen</span>
                </div>
                <div
                    x-show="open"
                    class="my-3">
                    <p class="mt-6 font-bold">Számlázási adatok:</p>

                    <?php if(count($invoice_addresses) > 0): ?>
                        <div class="my-3">
                            <label
                                class="text-xs text-gray-400"
                                for="select_invoice_address"
                            ><?php echo e(__('messages.invoice_address')); ?></label>
                            <select
                                class="w-full rounded-[5px] border border-black text-sm mt-1 p-2"
                                wire:model.live="selected_invoice_address">
                                <option value="null" selected disabled><?php echo e(__('messages.choose_invoice_address')); ?></option>
                                <!-- __BLOCK__ --><?php $__currentLoopData = $invoice_addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option class="text-xs" value="<?php echo e($item->id); ?>">
                                        <?php echo e($item->name . ' ('.$item->tax.') - '. $item->country .' '.$item->zip.' '.$item->city.', '.$item->address); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!-- __ENDBLOCK__ -->
                            </select>
                        </div>
                    <?php else: ?>
                        <div class="my-3">
                            <label
                                class="text-xs text-gray-400"
                                for="invoice_name"
                            ><?php echo e(__('messages.invoice_name')); ?></label>
                            <input
                                id="invoice_name"
                                name="invoice_name"
                                type="text"
                                wire:model="invoice_name"
                                placeholder="Pingvin János e.v."
                                class="w-full rounded-[5px] border border-black text-sm mt-1 p-2"
                                />
                        </div>

                        <div class="my-3">
                            <label
                                class="text-xs text-gray-400"
                                for="invoice_tax"
                            ><?php echo e(__('messages.invoice_tax')); ?></label>
                            <input
                                id="invoice_tax"
                                name="invoice_tax"
                                type="text"
                                wire:model="invoice_tax"
                                placeholder="1256752-2-6"
                                class="w-full rounded-[5px] border border-black text-sm mt-1 p-2"
                                />
                        </div>

                        <div class="my-3">
                            <label
                                class="text-xs text-gray-400"
                                for="delivery_country"
                            ><?php echo e(__('messages.delivery_country')); ?></label>
                            <input
                                id="delivery_country"
                                name="delivery_country"
                                type="text"
                                wire:model="delivery_country"
                                placeholder="Magyarország"
                                class="w-full rounded-[5px] border border-black text-sm mt-1 p-2"
                                />
                        </div>

                        <div class="my-3">
                            <label
                                class="text-xs text-gray-400"
                                for="invoice_zip"
                            ><?php echo e(__('messages.invoice_zip')); ?></label>
                            <input
                                id="invoice_zip"
                                name="invoice_zip"
                                type="text"
                                wire:model="invoice_zip"
                                placeholder="6721"
                                class="w-full rounded-[5px] border border-black text-sm mt-1 p-2"
                                />
                        </div>

                        <div class="my-3">
                            <label
                                class="text-xs text-gray-400"
                                for="invoice_city"
                            ><?php echo e(__('messages.invoice_city')); ?></label>
                            <input
                                id="invoice_city"
                                name="invoice_city"
                                type="text"
                                wire:model="invoice_city"
                                placeholder="Szeged"
                                class="w-full rounded-[5px] border border-black text-sm mt-1 p-2"
                                />
                        </div>

                        <div class="my-3">
                            <label
                                class="text-xs text-gray-400"
                                for="invoice_address"
                            ><?php echo e(__('messages.invoice_address')); ?></label>
                            <input
                                id="invoice_address"
                                name="invoice_address"
                                type="text"
                                wire:model="invoice_address"
                                placeholder="Szegedi utca 11 2 em. 5b a."
                                class="w-full rounded-[5px] border border-black text-sm mt-1 p-2"
                                />
                        </div>
                    <?php endif; ?> <!-- __ENDBLOCK__ -->

                </div>
            </div>

            <button
                type="submit"
                <?php if($submit_disabled): ?>
                    class="bg-gray-400 text-white py-3 px-5 rounded-[5px] text-sm my-6 w-full"
                    disabled
                <?php else: ?>
                    class="bg-black text-white py-3 px-5 rounded-[5px] text-sm my-6 w-full"
                <?php endif; ?>
                >
                Rendelés küldése
            </button>

            <p class="text-xs text-center text-gray-200">Készítette: <a href="https://roboda.hu" target="_blank">roboda.hu</a></p>
        </form>
    </div>
    
    <div class="top-0 left-0 flex flex-col items-end p-5 bg-gray-50 md:w-1/2 md:fixed md:h-screen md:shadow-inner">
        <div class="md:w-10/12">
            <header class="flex items-center justify-between py-5">
                <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('cart-button', []);

$__html = app('livewire')->mount($__name, $__params, 'L3QD2Gz', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                <a href="<?php echo e(route('home')); ?>">
                    <img class="w-20" src="<?php echo e(asset('images/logo-black.png')); ?>" alt="Ét-trend" />
                </a>
            </header>
            <p class="font-bold">Termékek</p>
            <div class="md:overflow-y-auto md:h-1/3 lg:h-max-2/3">
                <!-- __BLOCK__ --><?php $__currentLoopData = $cartFoods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="bg-white my-5 rounded-[5px] p-3 mx-auto">
                        <?php
                            $food = App\Models\Food::where('id', $item->food_id)->first();
                            $menuType = App\Models\MenuType::where('id', $food->menu_type_id)->first();
                        ?>
                        <div class="flex items-center justify-between">
                            <div class="">
                                <p class="text-sm font-semibold"><?php echo e($food->name); ?></p>
                                <div class="flex items-center">
                                    <span class="mr-2 text-xs font-medium"><?php echo e($food->date); ?></span>
                                    <span class="mt-1 text-xs"><?php echo e($menuType->name); ?></span>
                                </div>
                            </div>
                            <div class="mx-3">
                                <span class="ml-2 text-xs text-gray-700"><?php echo e($item->quantity); ?> adag</span>
                            </div>
                        </div>
                        <div class="flex items-center justify-between mt-4">
                            <div class="flex items-center">
                                <span class="ml-2 text-xs text-gray-700"><?php echo e($item->price); ?> Ft/adag</span>
                            </div>
                            <span class="font-bold"><?php echo e($item->quantity * $item->price); ?> Ft</span>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!-- __ENDBLOCK__ -->
            </div>
            <div class="my-5">
                <p class="my-1 text-sm"><span class="font-bold"><?php echo e(__('messages.foods_price')); ?></span> <span><?php echo e($total['food']); ?> Ft</span></p>
                <?php if($total['pack'] > 0): ?>
                    <p class="my-1 text-sm"><span class="font-bold"><?php echo e(__('messages.pack_price')); ?></span> <span><?php echo e($total['pack']); ?> Ft</span></p>
                <?php endif; ?>
                <?php if($total['delivery'] > 0): ?>
                    <p class="my-1 text-sm"><span class="font-bold"><?php echo e(__('messages.delivery_price')); ?></span> <span><?php echo e($total['delivery']); ?> Ft</span></p>
                <?php endif; ?>
                <?php if($total['payment'] > 0): ?>
                    <p class="my-1 text-sm"><span class="font-bold"><?php echo e(__('messages.payment_price')); ?></span> <span><?php echo e($total['payment']); ?> Ft</span></p>
                <?php endif; ?>
                <?php if($total['quantity_discount'] > 0): ?>
                    <p class="my-1 text-sm"><span class="font-bold"><?php echo e(__('messages.quantity_discount')); ?></span> <span class="text-green-800">-<?php echo e($total['quantity_discount']); ?> Ft</span></p>
                <?php endif; ?>
                <?php if($total['coupon'] > 0): ?>
                    <p class="my-1 text-sm"><span class="font-bold"><?php echo e(__('messages.coupon_price')); ?></span> <span class="text-green-800">-<?php echo e($total['coupon']); ?> Ft</span></p>
                <?php endif; ?> <!-- __ENDBLOCK__ -->
                <p class="mt-2 font-bold">Teljes ár: <span><?php echo e($total['total']); ?> Ft</span></p>
            </div>
            <div class="flex flex-col mt-1 mb-6">
                <label
                    class="text-xs text-gray-400"
                    for="coupon_code"><?php echo e(__('messages.coupon_code')); ?></label>
                <input
                    id="coupon_code"
                    class="w-full rounded-[5px] border border-black text-xs mt-1 p-2 lg:w-40"
                    wire:model.live.debounce.1000ms="coupon_code"
                    wire:loading.class="animate-pulse"
                    placeholder="ETTREND-KUPON"
                    type="text"
                    <?php if($coupon_field_disabled || !$logged_in): ?>
                        disabled
                    <?php endif; ?>
                    />

                <!-- __BLOCK__ --><?php if($coupon_field_disabled): ?>
                    <span class="mt-1 text-xs text-green-500"><?php echo e(__('messages.coupon_activated')); ?></span>
                <?php endif; ?> <!-- __ENDBLOCK__ -->

                <!-- __BLOCK__ --><?php if(!$logged_in): ?>
                    <div class="my-1">
                        <p class="text-xs text-gray-800"><?php echo e(__('messages.activate_coupon_after_login')); ?>. 
                            <a class="underline" href="<?php echo e(route('filament.admin.auth.login')); ?>"><?php echo e(__('messages.login')); ?></a></p>
                    </div>
                <?php endif; ?> <!-- __ENDBLOCK__ -->
            </div>
            <div class="flex items-center">
                <a class="my-1 mr-3 text-xs text-gray-300" href="<?php echo e(route('home')); ?>" target="_blank">Adatvédelmi tájékoztató</a>
                <a class="my-1 text-xs text-gray-300" href="https://simplepartner.hu/PaymentService/Fizetesi_tajekoztato.pdf" target="_blank">Simplepay fizetési tájékoztató</a>
            </div>
        </div>
    </div>
</div>
<?php /**PATH C:\app\ettrend_laravel\resources\views/livewire/checkout.blade.php ENDPATH**/ ?>