<?php
    $payment = \App\Models\Payment::find($order->payment_id);
?>
<html lang="hu">
    <head>
        <title>Sikeres rendelés - ettrend.hu</title>
        <meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
        <meta name="viewport" content="width=device-width">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Inter&display=swap" rel="stylesheet">
        <style>
            body {
                font-family: 'Inter', sans-serif;
                font-size: 14px;
            }
            table {
                border-spacing: 0;
            }
            .bordered-table,
            .bordered-table td {
                border: 1px solid #999;
            }
            .bordered-table td {
                padding: 0 15px;
            }
        </style>
    </head>
    <body>
        <div style="margin:15px 0 0 0;"></div>
        <svg xmlns="http://www.w3.org/2000/svg" height="20" width="20" viewBox="0 0 512 512"><!--!Font Awesome Free 6.5.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2023 Fonticons, Inc.--><path fill="#008000" d="M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM369 209L241 337c-9.4 9.4-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47L335 175c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9z"/></svg>

        <h1 style="font-weight:600;margin:5px 0 0 0;">Sikeres rendelés</h1>
        <p style="margin:0 0 15px 0;">Köszönjük a leadott rendelést.</p>

        <div style="display:flex;flex-direction:row;flex-wrap:wrap;">
            <table class="bordered-table" style="margin:25px 15px 25px 0;">
                <tr>
                    <td colspan="2" style="height:30px;backgrouns:#ccc;font-weight:600;">Általános adatok</td>
                </tr>
                <tr>
                    <td style="background:#ccc;font-weight:600;">Azonosító:</td>
                    <td style="font-weight:600;">#<?php echo e($order->id); ?></td>
                </tr>
                <tr>
                    <td style="background:#ccc;font-weight:600;">Rendelés dátuma:</td>
                    <td><?php echo e($order->created_at); ?></td>
                </tr>
                <tr>
                    <td style="background:#ccc;font-weight:600;">Teljes név</td>
                    <td><?php echo e($order->fullname); ?></td>
                </tr>
                <tr>
                    <td style="background:#ccc;font-weight:600;">Email</td>
                    <td><?php echo e($order->email); ?></td>
                </tr>
                <tr>
                    <td style="background:#ccc;font-weight:600;">Telefon</td>
                    <td><?php echo e($order->phone); ?></td>
                </tr>
                <tr>
                    <td style="background:#ccc;font-weight:600;">Fizetési mód</td>
                    <td><?php echo e($payment->name); ?></td>
                </tr>
                <tr>
                    <td style="background:#ccc;font-weight:600;">Fizetési státus</td>
                    <td><?php echo e(__($order->payment_status)); ?></td>
                </tr>
                <tr>
                    <td style="background:#ccc;font-weight:600;">Megjegyzés</td>
                    <td><?php echo e($order->comment ?? '-'); ?></td>
                </tr>
            </table>

            <table class="bordered-table" style="margin:25px 15px;">
                <tr>
                    <td colspan="2" style="height:30px;backgrouns:#ccc;font-weight:600;">Szállítási adatok</td>
                </tr>
                <tr>
                    <td style="background:#ccc;font-weight:600;">Ország:</td>
                    <td><?php echo e($order->delivery_country); ?></td>
                </tr>
                <tr>
                    <td style="background:#ccc;font-weight:600;">Irányítószám:</td>
                    <td><?php echo e($order->delivery_zip); ?></td>
                </tr>
                <tr>
                    <td style="background:#ccc;font-weight:600;">Város:</td>
                    <td><?php echo e($order->delivery_city); ?></td>
                </tr>
                <tr>
                    <td style="background:#ccc;font-weight:600;">Cím:</td>
                    <td><?php echo e($order->delivery_address); ?></td>
                </tr>
            </table>

            <?php if($order->invoice_zip != null): ?>
                <table class="bordered-table">
                    <tr>
                        <td colspan="2" style="height:30px;backgrouns:#ccc;font-weight:600;">Számlázási adatok</td>
                    </tr>
                    <tr>
                        <td style="background:#ccc;font-weight:600;">Név:</td>
                        <td><?php echo e($order->invoice_name); ?></td>
                    </tr>
                    <tr>
                        <td style="background:#ccc;font-weight:600;">Adószám:</td>
                        <td><?php echo e($order->invoice_tax); ?></td>
                    </tr>
                    <tr>
                        <td style="background:#ccc;font-weight:600;">Ország:</td>
                        <td><?php echo e($order->invoice_country); ?></td>
                    </tr>
                    <tr>
                        <td style="background:#ccc;font-weight:600;">Irányítószám:</td>
                        <td><?php echo e($order->invoice_zip); ?></td>
                    </tr>
                    <tr>
                        <td style="background:#ccc;font-weight:600;">Város:</td>
                        <td><?php echo e($order->invoice_city); ?></td>
                    </tr>
                    <tr>
                        <td style="background:#ccc;font-weight:600;">Cím:</td>
                        <td><?php echo e($order->invoice_address); ?></td>
                    </tr>
                </table>
            <?php endif; ?>
        </div>

        <table class="bordered-table" style="margin:25px 0;">
            <tr style="height:50px;background:#ccc;font-weight:600;">
                <td>Dátum</td>
                <td>Termék</td>
                <td>Mennyiség</td>
                <td>Egyég ár</td>
                <td>Összesen</td>
            </tr>
            <?php $__currentLoopData = $orderFoods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $orderFood): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $food = \App\Models\Food::find($orderFood->food_id);
                    $menuType = \App\Models\MenuType::find($food->menu_type_id);
                    $date = new Datetime($food->date);
                    $week = $date->format('W');
                    $day = __($date->format('l'));
                ?>
                <tr >
                    <td>
                        <p><?php echo e($date->format('Y.m.d')); ?></p>
                        <p>
                            <span><?php echo e($day); ?></span>
                            -
                            <span>(<?php echo e($week); ?>. hét)</span>
                        </p>
                    </td>
                    <td>
                        <span><?php echo e($food->name); ?></span><br/>
                        <span style="font-size:12px;">(<?php echo e($menuType->name); ?>)</span>
                    </td>
                    <td><?php echo e($orderFood->quantity); ?> adag</td>
                    <td><?php echo e($orderFood->price); ?> Ft</td>
                    <td style="font-weight:600;"><?php echo e($orderFood->quantity * $orderFood->price); ?> Ft</td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <tr style="height:50px;background:#ccc;">
                <td colspan="4">Ételek ára</td>
                <td><?php echo e($total['food']); ?> Ft</td>
            </tr>
            <?php if($total['pack'] > 0): ?>
                <tr style="height:50px;background:#ccc;">
                    <td colspan="4">Csomagolás</td>
                    <td><?php echo e($total['pack']); ?> Ft</td>
                </tr>
            <?php endif; ?>
            <?php if($total['delivery'] > 0): ?>
                <tr style="height:50px;background:#ccc;">
                    <td colspan="4">Szállítási költség</td>
                    <td><?php echo e($total['delivery']); ?> Ft</td>
                </tr>
            <?php endif; ?>
            <?php if($total['payment'] > 0): ?>
                <tr style="height:50px;background:#ccc;">
                    <td colspan="4">Fizetési mód felár</td>
                    <td><?php echo e($total['payment']); ?> Ft</td>
                </tr>
            <?php endif; ?>
            <?php if($total['quantity_discount'] > 0): ?>
                <tr style="height:50px;background:#ccc;">
                    <td colspan="4">Mennyiségi kedvezmény</td>
                    <td style="color:green;">-<?php echo e($total['quantity_discount']); ?> Ft</td>
                </tr>
            <?php endif; ?>
            <?php if($total['coupon'] > 0): ?>
                <tr style="height:50px;background:#ccc;">
                    <td colspan="4">Kupon kedvezmény</td>
                    <td style="color:green;">-<?php echo e($total['coupon']); ?> Ft</td>
                </tr>
            <?php endif; ?>
            <tr style="height:50px;background:#ccc;font-weight:600;">
                <td colspan="4">
                    <p style="margin:0;padding:0;">Összesen</p>
                    <p style="font-size:12px;color:#999;margin:0;padding:0;">Az áraink bruttóban értendőek!</p>
                </td>
                <td><?php echo e($total['total']); ?> Ft</td>
            </tr>
        </table>

        <table>
            <tr>
                <td>
                    <p style="margin:0;padding:0;font-size:12px;">2023 © Menü udvar Kft.</p>
                    <p style="color:#999;margin:0;padding:0;font-size:12px;">A weboldalt készítette és üzemelteti: 
                        <a style="color:#999;" href="https://roboda.hu">roboda.hu</a>
                    </p>
                </td>
            </tr>
        </table>
    </body>
</html><?php /**PATH /cphome/rh31796/public_html/ettrend.hu/resources/views/mail/order/confirmation.blade.php ENDPATH**/ ?>