<?php if(count($foods) > 0): ?>
<div class="my-5">
    <div class="flex overflow-x-auto bg-gray-100 border-l border-t border-gray-600 w-[335px] md:w-[720px] lg:w-[950px] xl:w-[1121px] lg:mx-auto">
        
        <div class="w-40">
            <div class="flex items-center justify-center w-40 h-12 border-b border-r border-gray-600">
                <span class="font-bold">Ét-trend</span>
            </div>
            <?php $__currentLoopData = $menuTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menuType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="flex flex-col items-center justify-center w-40 h-40 bg-gray-200 border-b border-r border-gray-600">
                    <p class="font-semibold text-center text-gray-800"><?php echo e($menuType->name); ?></p>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        
        <div class="flex">
            <?php
                $index = 1
            ?>
            <?php $__currentLoopData = $foods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $food): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($index == 1): ?>
                    <div class="flex flex-col">
                        <div class="flex flex-col items-center justify-center w-40 h-12 bg-gray-200 border-b border-r border-gray-600">
                            <p><?php echo e(__(Carbon\Carbon::create($food->date)->format('l'))); ?></p>
                            <span class="text-sm font-light"><?php echo e($food->date); ?></span>
                        </div>
                <?php endif; ?>
                        <div class="flex flex-col items-center justify-between w-40 h-40 p-1 bg-white border-b border-r border-gray-600">
                            <?php if($food->price > 0): ?>
                                <div>
                                    <p class="text-xs text-center"><?php echo e($food->name); ?></p>
                                    <div class="flex items-center justify-center my-1"><?php echo App\Services\AllergensService::renderIcons($food->allergens); ?></div>
                                    <p class="text-xs text-center text-gray-600"><?php echo e($food->price); ?> Ft</p>
                                </div>
                                <div>
                                    <?php if($food->closing_at > now()): ?>
                                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('add-cart-button', ['id' => $food->id,'lazy' => true]);

$__html = app('livewire')->mount($__name, $__params, 'Yox4knJ', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                    <?php else: ?>
                                        <p class="mt-2 mb-3 text-xs text-center text-red-200">Lejárt menü</p>
                                    <?php endif; ?>
                                </div>
                            <?php else: ?>
                                <div class="flex items-center justify-center h-full">
                                    <span class="text-3xl text-gray-200 material-symbols-outlined">
                                        cancel
                                    </span>
                                </div>
                            <?php endif; ?>
                        </div>
                <?php if($index == count($menuTypes)): ?>
                    </div>
                    <?php
                        $index = 1
                    ?>
                <?php else: ?>
                    <?php
                        $index++
                    ?>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>
<?php else: ?>
    <div class="my-10 text-center">
        <span class="text-gray-500 material-symbols-outlined">error</span>
        <p class="text-xl font-medium text-gray-500"><?php echo e(__('messages.no_menu_text')); ?></p>
        <p class="text-gray-400"><?php echo e(__('messages.try_later')); ?></p>
    </div>
<?php endif; ?>
<?php /**PATH /cphome/rh31796/public_html/ettrend.hu/resources/views/components/food-table.blade.php ENDPATH**/ ?>