<div class="my-5">
    <div class="relative overflow-x-auto border sm:rounded-lg">
        <table class="w-full text-sm text-left text-gray-500">
            <thead class="text-xs text-gray-700 uppercase bg-gray-50">
                <tr>
                    <th scope="col" class="px-6 py-3">
                        Menü
                    </th>
                    <th scope="col" class="px-6 py-3">
                        Dátum (Hét)
                    </th>
                    <th scope="col" class="px-6 py-3">
                        Név
                    </th>
                    <th scope="col" class="px-6 py-3">
                        Egység ár
                    </th>
                    <th scope="col" class="px-6 py-3">
                        Mennyiség
                    </th>
                    <th scope="col" class="px-6 py-3">
                        Összesen
                    </th>
                </tr>
            </thead>
            <tbody>
                <!-- __BLOCK__ --><?php $__currentLoopData = $orderFoods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $food = App\Models\Food::where('id', $item->food_id)->first();
                        $menuType = App\Models\MenuType::where('id', $food->menu_type_id)->first();
                    ?>
                    <tr class="bg-white border-b">
                        <th scope="row" class="px-6 py-4 font-medium text-gray-900 whitespace-nowrap">
                            <p><?php echo e($menuType->name); ?></p>
                        </th>
                        <td class="px-6 py-4">
                            <p><?php echo e($food->date); ?> <span class="text-xs">(<?php echo e(Carbon\Carbon::parse($food->data)->format('W')); ?>. hét)</span></p>
                        </td>
                        <td class="px-6 py-4">
                            <p><?php echo e($food->name); ?></p>
                        </td>
                        <td class="px-6 py-4">
                            <p><?php echo e($item->price); ?> Ft</p>
                        </td>
                        <td class="px-6 py-4">
                            <p><?php echo e($item->quantity); ?> adag</p>
                        </td>
                        <td class="px-6 py-4">
                            <p><?php echo e($total['items'][$item->id]); ?> Ft</p>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!-- __ENDBLOCK__ -->
            </tbody>
            <tfoot>
                <tr>
                    <td class="px-6 py-4" colspan="6">
                        <p class="my-1"><span class="font-bold"><?php echo e(__('messages.foods_price')); ?>:</span> <span><?php echo e($total['food']); ?> Ft</span></p>
                        <?php if($total['pack'] > 0): ?>
                            <p class="my-1"><span class="font-bold"><?php echo e(__('messages.pack_price')); ?>:</span> <span><?php echo e($total['pack']); ?> Ft</span></p>
                        <?php endif; ?>
                        <?php if($total['delivery'] > 0): ?>
                            <p class="my-1"><span class="font-bold"><?php echo e(__('messages.delivery_price')); ?>:</span> <span><?php echo e($total['delivery']); ?> Ft</span></p>
                        <?php endif; ?>
                        <?php if($total['payment'] > 0): ?>
                            <p class="my-1"><span class="font-bold"><?php echo e(__('messages.payment_price')); ?>:</span> <span><?php echo e($total['payment']); ?> Ft</span></p>
                        <?php endif; ?>
                        <?php if($total['quantity_discount'] > 0): ?>
                            <p class="my-1 text-sm"><span class="font-bold"><?php echo e(__('messages.quantity_discount')); ?></span> <span class="text-green-800">-<?php echo e($total['quantity_discount']); ?> Ft</span></p>
                        <?php endif; ?>
                        <?php if($total['coupon'] > 0): ?>
                            <p class="my-1"><span class="font-bold"><?php echo e(__('messages.coupon_price')); ?>:</span> <span><?php echo e($total['coupon']); ?> Ft</span></p>
                        <?php endif; ?> <!-- __ENDBLOCK__ -->
                        <p class="my-2 font-bold">Teljes ár: <span><?php echo e($total['total']); ?> Ft</span></p>
                    </td>
                </tr>
            </tfoot>
        </table>
    </div>
</div>
<?php /**PATH /cphome/rh31796/public_html/ettrend.hu/resources/views/livewire/order-food-list.blade.php ENDPATH**/ ?>